/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPM_HANDLE;

public class TPM2_Duplicate_REQUEST
extends TpmStructure {
    public TPM_HANDLE objectHandle;
    public TPM_HANDLE newParentHandle;
    public byte[] encryptionKeyIn;
    public TPMT_SYM_DEF_OBJECT symmetricAlg;

    public TPM2_Duplicate_REQUEST(TPM_HANDLE _objectHandle, TPM_HANDLE _newParentHandle, byte[] _encryptionKeyIn, TPMT_SYM_DEF_OBJECT _symmetricAlg) {
        this.objectHandle = _objectHandle;
        this.newParentHandle = _newParentHandle;
        this.encryptionKeyIn = _encryptionKeyIn;
        this.symmetricAlg = _symmetricAlg;
    }

    public TPM2_Duplicate_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.objectHandle.toTpm(buf);
        this.newParentHandle.toTpm(buf);
        buf.writeInt(this.encryptionKeyIn != null ? this.encryptionKeyIn.length : 0, 2);
        buf.write(this.encryptionKeyIn);
        this.symmetricAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.objectHandle = TPM_HANDLE.fromTpm(buf);
        this.newParentHandle = TPM_HANDLE.fromTpm(buf);
        int _encryptionKeyInSize = buf.readInt(2);
        this.encryptionKeyIn = new byte[_encryptionKeyInSize];
        buf.readArrayOfInts(this.encryptionKeyIn, 1, _encryptionKeyInSize);
        this.symmetricAlg = TPMT_SYM_DEF_OBJECT.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_Duplicate_REQUEST fromTpm(byte[] x) {
        TPM2_Duplicate_REQUEST ret = new TPM2_Duplicate_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_Duplicate_REQUEST fromTpm(InByteBuf buf) {
        TPM2_Duplicate_REQUEST ret = new TPM2_Duplicate_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Duplicate_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "TPM_HANDLE", "newParentHandle", this.newParentHandle);
        _p.add(d, "byte", "encryptionKeyIn", this.encryptionKeyIn);
        _p.add(d, "TPMT_SYM_DEF_OBJECT", "symmetricAlg", this.symmetricAlg);
    }
}

