/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_HMAC_Start_REQUEST
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] auth;
    public TPM_ALG_ID hashAlg;

    public TPM2_HMAC_Start_REQUEST(TPM_HANDLE _handle, byte[] _auth, TPM_ALG_ID _hashAlg) {
        this.handle = _handle;
        this.auth = _auth;
        this.hashAlg = _hashAlg;
    }

    public TPM2_HMAC_Start_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.auth != null ? this.auth.length : 0, 2);
        buf.write(this.auth);
        this.hashAlg.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _authSize = buf.readInt(2);
        this.auth = new byte[_authSize];
        buf.readArrayOfInts(this.auth, 1, _authSize);
        this.hashAlg = TPM_ALG_ID.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_HMAC_Start_REQUEST fromTpm(byte[] x) {
        TPM2_HMAC_Start_REQUEST ret = new TPM2_HMAC_Start_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_HMAC_Start_REQUEST fromTpm(InByteBuf buf) {
        TPM2_HMAC_Start_REQUEST ret = new TPM2_HMAC_Start_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_HMAC_Start_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "auth", this.auth);
        _p.add(d, "TPM_ALG_ID", "hashAlg", this.hashAlg);
    }
}

