/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_PolicyCpHash_REQUEST
extends TpmStructure {
    public TPM_HANDLE policySession;
    public byte[] cpHashA;

    public TPM2_PolicyCpHash_REQUEST(TPM_HANDLE _policySession, byte[] _cpHashA) {
        this.policySession = _policySession;
        this.cpHashA = _cpHashA;
    }

    public TPM2_PolicyCpHash_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.policySession.toTpm(buf);
        buf.writeInt(this.cpHashA != null ? this.cpHashA.length : 0, 2);
        buf.write(this.cpHashA);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.policySession = TPM_HANDLE.fromTpm(buf);
        int _cpHashASize = buf.readInt(2);
        this.cpHashA = new byte[_cpHashASize];
        buf.readArrayOfInts(this.cpHashA, 1, _cpHashASize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_PolicyCpHash_REQUEST fromTpm(byte[] x) {
        TPM2_PolicyCpHash_REQUEST ret = new TPM2_PolicyCpHash_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_PolicyCpHash_REQUEST fromTpm(InByteBuf buf) {
        TPM2_PolicyCpHash_REQUEST ret = new TPM2_PolicyCpHash_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_PolicyCpHash_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "policySession", this.policySession);
        _p.add(d, "byte", "cpHashA", this.cpHashA);
    }
}

