/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ENC_SCHEME_OAEP;
import tss.tpm.TPMS_ENC_SCHEME_RSAES;
import tss.tpm.TPMS_KEY_SCHEME_ECDH;
import tss.tpm.TPMS_KEY_SCHEME_ECMQV;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_RSA_Encrypt_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyHandle;
    public byte[] message;
    public TPMU_ASYM_SCHEME inScheme;
    public byte[] label;

    public TPM2_RSA_Encrypt_REQUEST(TPM_HANDLE _keyHandle, byte[] _message, TPMU_ASYM_SCHEME _inScheme, byte[] _label) {
        this.keyHandle = _keyHandle;
        this.message = _message;
        this.inScheme = _inScheme;
        this.label = _label;
    }

    public TPM2_RSA_Encrypt_REQUEST() {
    }

    public int GetUnionSelector_inScheme() {
        if (this.inScheme instanceof TPMS_KEY_SCHEME_ECDH) {
            return 25;
        }
        if (this.inScheme instanceof TPMS_KEY_SCHEME_ECMQV) {
            return 29;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSASSA) {
            return 20;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_RSAPSS) {
            return 22;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDSA) {
            return 24;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECDAA) {
            return 26;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_SM2) {
            return 27;
        }
        if (this.inScheme instanceof TPMS_SIG_SCHEME_ECSCHNORR) {
            return 28;
        }
        if (this.inScheme instanceof TPMS_ENC_SCHEME_RSAES) {
            return 21;
        }
        if (this.inScheme instanceof TPMS_ENC_SCHEME_OAEP) {
            return 23;
        }
        if (this.inScheme instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.inScheme instanceof TPMS_NULL_ASYM_SCHEME) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.message != null ? this.message.length : 0, 2);
        buf.write(this.message);
        buf.writeInt(this.GetUnionSelector_inScheme(), 2);
        this.inScheme.toTpm(buf);
        buf.writeInt(this.label != null ? this.label.length : 0, 2);
        buf.write(this.label);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _messageSize = buf.readInt(2);
        this.message = new byte[_messageSize];
        buf.readArrayOfInts(this.message, 1, _messageSize);
        int _inSchemeScheme = buf.readInt(2);
        this.inScheme = null;
        if (_inSchemeScheme == TPM_ALG_ID.ECDH.toInt()) {
            this.inScheme = new TPMS_KEY_SCHEME_ECDH();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECMQV.toInt()) {
            this.inScheme = new TPMS_KEY_SCHEME_ECMQV();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSASSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSASSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSAPSS.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_RSAPSS();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDSA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDSA();
        } else if (_inSchemeScheme == TPM_ALG_ID.ECDAA.toInt()) {
            this.inScheme = new TPMS_SIG_SCHEME_ECDAA();
        } else if (_inSchemeScheme == TPM_ALG_ID.RSAES.toInt()) {
            this.inScheme = new TPMS_ENC_SCHEME_RSAES();
        } else if (_inSchemeScheme == TPM_ALG_ID.OAEP.toInt()) {
            this.inScheme = new TPMS_ENC_SCHEME_OAEP();
        } else if (_inSchemeScheme == TPM_ALG_ID.ANY.toInt()) {
            this.inScheme = new TPMS_SCHEME_HASH();
        } else if (_inSchemeScheme == TPM_ALG_ID.NULL.toInt()) {
            this.inScheme = new TPMS_NULL_ASYM_SCHEME();
        }
        if (this.inScheme == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.inScheme.initFromTpm(buf);
        int _labelSize = buf.readInt(2);
        this.label = new byte[_labelSize];
        buf.readArrayOfInts(this.label, 1, _labelSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_RSA_Encrypt_REQUEST fromTpm(byte[] x) {
        TPM2_RSA_Encrypt_REQUEST ret = new TPM2_RSA_Encrypt_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_RSA_Encrypt_REQUEST fromTpm(InByteBuf buf) {
        TPM2_RSA_Encrypt_REQUEST ret = new TPM2_RSA_Encrypt_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_RSA_Encrypt_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "message", this.message);
        _p.add(d, "TPMU_ASYM_SCHEME", "inScheme", this.inScheme);
        _p.add(d, "byte", "label", this.label);
    }
}

