/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_SequenceComplete_REQUEST
extends TpmStructure {
    public TPM_HANDLE sequenceHandle;
    public byte[] buffer;
    public TPM_HANDLE hierarchy;

    public TPM2_SequenceComplete_REQUEST(TPM_HANDLE _sequenceHandle, byte[] _buffer, TPM_HANDLE _hierarchy) {
        this.sequenceHandle = _sequenceHandle;
        this.buffer = _buffer;
        this.hierarchy = _hierarchy;
    }

    public TPM2_SequenceComplete_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.sequenceHandle.toTpm(buf);
        buf.writeInt(this.buffer != null ? this.buffer.length : 0, 2);
        buf.write(this.buffer);
        this.hierarchy.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.sequenceHandle = TPM_HANDLE.fromTpm(buf);
        int _bufferSize = buf.readInt(2);
        this.buffer = new byte[_bufferSize];
        buf.readArrayOfInts(this.buffer, 1, _bufferSize);
        this.hierarchy = TPM_HANDLE.fromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_SequenceComplete_REQUEST fromTpm(byte[] x) {
        TPM2_SequenceComplete_REQUEST ret = new TPM2_SequenceComplete_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_SequenceComplete_REQUEST fromTpm(InByteBuf buf) {
        TPM2_SequenceComplete_REQUEST ret = new TPM2_SequenceComplete_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_SequenceComplete_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "sequenceHandle", this.sequenceHandle);
        _p.add(d, "byte", "buffer", this.buffer);
        _p.add(d, "TPM_HANDLE", "hierarchy", this.hierarchy);
    }
}

