/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_CAPABILITIES;
import tss.tpm.TPM_CC;

public class TPML_CC
extends TpmStructure
implements TPMU_CAPABILITIES {
    public TPM_CC[] commandCodes;

    public TPML_CC(TPM_CC[] _commandCodes) {
        this.commandCodes = _commandCodes;
    }

    public TPML_CC() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.commandCodes != null ? this.commandCodes.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.commandCodes);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _count = buf.readInt(4);
        this.commandCodes = new TPM_CC[_count];
        for (int j = 0; j < _count; ++j) {
            this.commandCodes[j] = TPM_CC.fromTpm(buf);
        }
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPML_CC fromTpm(byte[] x) {
        TPML_CC ret = new TPML_CC();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPML_CC fromTpm(InByteBuf buf) {
        TPML_CC ret = new TPML_CC();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPML_CC");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_CC", "commandCodes", this.commandCodes);
    }
}

