/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_AT;

public class TPMS_AC_OUTPUT
extends TpmStructure {
    public TPM_AT tag;
    public int data;

    public TPMS_AC_OUTPUT(TPM_AT _tag, int _data) {
        this.tag = _tag;
        this.data = _data;
    }

    public TPMS_AC_OUTPUT() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.tag.toTpm(buf);
        buf.write(this.data);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.tag = TPM_AT.fromTpm(buf);
        this.data = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_AC_OUTPUT fromTpm(byte[] x) {
        TPMS_AC_OUTPUT ret = new TPMS_AC_OUTPUT();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_AC_OUTPUT fromTpm(InByteBuf buf) {
        TPMS_AC_OUTPUT ret = new TPMS_AC_OUTPUT();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_AC_OUTPUT");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_AT", "tag", this.tag);
        _p.add(d, "uint", "data", this.data);
    }
}

