/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPM_ALG_ID;

public class TPMS_COMMAND_AUDIT_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public long auditCounter;
    public TPM_ALG_ID digestAlg;
    public byte[] auditDigest;
    public byte[] commandDigest;

    public TPMS_COMMAND_AUDIT_INFO(long _auditCounter, TPM_ALG_ID _digestAlg, byte[] _auditDigest, byte[] _commandDigest) {
        this.auditCounter = _auditCounter;
        this.digestAlg = _digestAlg;
        this.auditDigest = _auditDigest;
        this.commandDigest = _commandDigest;
    }

    public TPMS_COMMAND_AUDIT_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.auditCounter);
        this.digestAlg.toTpm(buf);
        buf.writeInt(this.auditDigest != null ? this.auditDigest.length : 0, 2);
        buf.write(this.auditDigest);
        buf.writeInt(this.commandDigest != null ? this.commandDigest.length : 0, 2);
        buf.write(this.commandDigest);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.auditCounter = buf.readLong();
        this.digestAlg = TPM_ALG_ID.fromTpm(buf);
        int _auditDigestSize = buf.readInt(2);
        this.auditDigest = new byte[_auditDigestSize];
        buf.readArrayOfInts(this.auditDigest, 1, _auditDigestSize);
        int _commandDigestSize = buf.readInt(2);
        this.commandDigest = new byte[_commandDigestSize];
        buf.readArrayOfInts(this.commandDigest, 1, _commandDigestSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_COMMAND_AUDIT_INFO fromTpm(byte[] x) {
        TPMS_COMMAND_AUDIT_INFO ret = new TPMS_COMMAND_AUDIT_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_COMMAND_AUDIT_INFO fromTpm(InByteBuf buf) {
        TPMS_COMMAND_AUDIT_INFO ret = new TPMS_COMMAND_AUDIT_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_COMMAND_AUDIT_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "ulong", "auditCounter", this.auditCounter);
        _p.add(d, "TPM_ALG_ID", "digestAlg", this.digestAlg);
        _p.add(d, "byte", "auditDigest", this.auditDigest);
        _p.add(d, "byte", "commandDigest", this.commandDigest);
    }
}

