/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMA_LOCALITY;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPM_ALG_ID;

public class TPMS_CREATION_DATA
extends TpmStructure {
    public TPMS_PCR_SELECTION[] pcrSelect;
    public byte[] pcrDigest;
    public TPMA_LOCALITY locality;
    public TPM_ALG_ID parentNameAlg;
    public byte[] parentName;
    public byte[] parentQualifiedName;
    public byte[] outsideInfo;

    public TPMS_CREATION_DATA(TPMS_PCR_SELECTION[] _pcrSelect, byte[] _pcrDigest, TPMA_LOCALITY _locality, TPM_ALG_ID _parentNameAlg, byte[] _parentName, byte[] _parentQualifiedName, byte[] _outsideInfo) {
        this.pcrSelect = _pcrSelect;
        this.pcrDigest = _pcrDigest;
        this.locality = _locality;
        this.parentNameAlg = _parentNameAlg;
        this.parentName = _parentName;
        this.parentQualifiedName = _parentQualifiedName;
        this.outsideInfo = _outsideInfo;
    }

    public TPMS_CREATION_DATA() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.pcrSelect != null ? this.pcrSelect.length : 0, 4);
        buf.writeArrayOfTpmObjects(this.pcrSelect);
        buf.writeInt(this.pcrDigest != null ? this.pcrDigest.length : 0, 2);
        buf.write(this.pcrDigest);
        this.locality.toTpm(buf);
        this.parentNameAlg.toTpm(buf);
        buf.writeInt(this.parentName != null ? this.parentName.length : 0, 2);
        buf.write(this.parentName);
        buf.writeInt(this.parentQualifiedName != null ? this.parentQualifiedName.length : 0, 2);
        buf.write(this.parentQualifiedName);
        buf.writeInt(this.outsideInfo != null ? this.outsideInfo.length : 0, 2);
        buf.write(this.outsideInfo);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _pcrSelectCount = buf.readInt(4);
        this.pcrSelect = new TPMS_PCR_SELECTION[_pcrSelectCount];
        for (int j = 0; j < _pcrSelectCount; ++j) {
            this.pcrSelect[j] = new TPMS_PCR_SELECTION();
        }
        buf.readArrayOfTpmObjects(this.pcrSelect, _pcrSelectCount);
        int _pcrDigestSize = buf.readInt(2);
        this.pcrDigest = new byte[_pcrDigestSize];
        buf.readArrayOfInts(this.pcrDigest, 1, _pcrDigestSize);
        int _locality = buf.readInt(1);
        this.locality = TPMA_LOCALITY.fromInt(_locality);
        this.parentNameAlg = TPM_ALG_ID.fromTpm(buf);
        int _parentNameSize = buf.readInt(2);
        this.parentName = new byte[_parentNameSize];
        buf.readArrayOfInts(this.parentName, 1, _parentNameSize);
        int _parentQualifiedNameSize = buf.readInt(2);
        this.parentQualifiedName = new byte[_parentQualifiedNameSize];
        buf.readArrayOfInts(this.parentQualifiedName, 1, _parentQualifiedNameSize);
        int _outsideInfoSize = buf.readInt(2);
        this.outsideInfo = new byte[_outsideInfoSize];
        buf.readArrayOfInts(this.outsideInfo, 1, _outsideInfoSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_CREATION_DATA fromTpm(byte[] x) {
        TPMS_CREATION_DATA ret = new TPMS_CREATION_DATA();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_CREATION_DATA fromTpm(InByteBuf buf) {
        TPMS_CREATION_DATA ret = new TPMS_CREATION_DATA();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_CREATION_DATA");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_PCR_SELECTION", "pcrSelect", this.pcrSelect);
        _p.add(d, "byte", "pcrDigest", this.pcrDigest);
        _p.add(d, "TPMA_LOCALITY", "locality", this.locality);
        _p.add(d, "TPM_ALG_ID", "parentNameAlg", this.parentNameAlg);
        _p.add(d, "byte", "parentName", this.parentName);
        _p.add(d, "byte", "parentQualifiedName", this.parentQualifiedName);
        _p.add(d, "byte", "outsideInfo", this.outsideInfo);
    }
}

