/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_PUBLIC_ID;
import tss.tpm.TPMU_SENSITIVE_CREATE;

public class TPMS_DERIVE
extends TpmStructure
implements TPMU_SENSITIVE_CREATE,
TPMU_PUBLIC_ID {
    public byte[] label;
    public byte[] context;

    public TPMS_DERIVE(byte[] _label, byte[] _context) {
        this.label = _label;
        this.context = _context;
    }

    public TPMS_DERIVE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.label != null ? this.label.length : 0, 2);
        buf.write(this.label);
        buf.writeInt(this.context != null ? this.context.length : 0, 2);
        buf.write(this.context);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _labelSize = buf.readInt(2);
        this.label = new byte[_labelSize];
        buf.readArrayOfInts(this.label, 1, _labelSize);
        int _contextSize = buf.readInt(2);
        this.context = new byte[_contextSize];
        buf.readArrayOfInts(this.context, 1, _contextSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_DERIVE fromTpm(byte[] x) {
        TPMS_DERIVE ret = new TPMS_DERIVE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_DERIVE fromTpm(InByteBuf buf) {
        TPMS_DERIVE ret = new TPMS_DERIVE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_DERIVE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "label", this.label);
        _p.add(d, "byte", "context", this.context);
    }
}

