/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_ATTEST;

public class TPMS_NV_CERTIFY_INFO
extends TpmStructure
implements TPMU_ATTEST {
    public byte[] indexName;
    public short offset;
    public byte[] nvContents;

    public TPMS_NV_CERTIFY_INFO(byte[] _indexName, int _offset, byte[] _nvContents) {
        this.indexName = _indexName;
        this.offset = (short)_offset;
        this.nvContents = _nvContents;
    }

    public TPMS_NV_CERTIFY_INFO() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.indexName != null ? this.indexName.length : 0, 2);
        buf.write(this.indexName);
        buf.write(this.offset);
        buf.writeInt(this.nvContents != null ? this.nvContents.length : 0, 2);
        buf.write(this.nvContents);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _indexNameSize = buf.readInt(2);
        this.indexName = new byte[_indexNameSize];
        buf.readArrayOfInts(this.indexName, 1, _indexNameSize);
        this.offset = (short)buf.readInt(2);
        int _nvContentsSize = buf.readInt(2);
        this.nvContents = new byte[_nvContentsSize];
        buf.readArrayOfInts(this.nvContents, 1, _nvContentsSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_NV_CERTIFY_INFO fromTpm(byte[] x) {
        TPMS_NV_CERTIFY_INFO ret = new TPMS_NV_CERTIFY_INFO();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_NV_CERTIFY_INFO fromTpm(InByteBuf buf) {
        TPMS_NV_CERTIFY_INFO ret = new TPMS_NV_CERTIFY_INFO();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_NV_CERTIFY_INFO");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "indexName", this.indexName);
        _p.add(d, "ushort", "offset", this.offset);
        _p.add(d, "byte", "nvContents", this.nvContents);
    }
}

