/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;

public class TPMS_PCR_SELECTION
extends TpmStructure {
    public TPM_ALG_ID hash;
    public byte[] pcrSelect;

    public TPMS_PCR_SELECTION(TPM_ALG_ID _hash, byte[] _pcrSelect) {
        this.hash = _hash;
        this.pcrSelect = _pcrSelect;
    }

    public TPMS_PCR_SELECTION() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.hash.toTpm(buf);
        buf.writeInt(this.pcrSelect != null ? this.pcrSelect.length : 0, 1);
        buf.write(this.pcrSelect);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        int _sizeofSelect = buf.readInt(1);
        this.pcrSelect = new byte[_sizeofSelect];
        buf.readArrayOfInts(this.pcrSelect, 1, _sizeofSelect);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_PCR_SELECTION fromTpm(byte[] x) {
        TPMS_PCR_SELECTION ret = new TPMS_PCR_SELECTION();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_PCR_SELECTION fromTpm(InByteBuf buf) {
        TPMS_PCR_SELECTION ret = new TPMS_PCR_SELECTION();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_PCR_SELECTION");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte", "pcrSelect", this.pcrSelect);
    }

    public TPMS_PCR_SELECTION(TPM_ALG_ID pcrAlg, int pcrIndex) {
        this.hash = pcrAlg;
        int sz = 3;
        if (pcrIndex / 8 + 1 > sz) {
            sz = pcrIndex / 8 + 1;
        }
        this.pcrSelect = new byte[sz];
        this.pcrSelect[pcrIndex / 8] = (byte)(1 << pcrIndex % 8);
    }

    public static TPMS_PCR_SELECTION[] CreateSelectionArray(TPM_ALG_ID pcrAlg, int pcrIndex) {
        TPMS_PCR_SELECTION[] arr = new TPMS_PCR_SELECTION[]{new TPMS_PCR_SELECTION(pcrAlg, pcrIndex)};
        return arr;
    }

    public TPMS_PCR_SELECTION(TPM_ALG_ID pcrAlg, int[] pcrIndices) {
        int j;
        this.hash = pcrAlg;
        int pcrMax = 0;
        for (j = 0; j < pcrIndices.length; ++j) {
            if (pcrIndices[j] <= pcrMax) continue;
            pcrMax = pcrIndices[j];
        }
        if (pcrMax < 23) {
            pcrMax = 23;
        }
        this.pcrSelect = new byte[pcrMax / 8 + 1];
        for (j = 0; j < pcrIndices.length; ++j) {
            int n = pcrIndices[j] / 8;
            this.pcrSelect[n] = (byte)(this.pcrSelect[n] | (byte)(1 << pcrIndices[j] % 8));
        }
    }
}

