/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_ECC_PARAMETER;
import tss.tpm.TPM2B_PRIVATE_KEY_RSA;
import tss.tpm.TPM2B_PRIVATE_VENDOR_SPECIFIC;
import tss.tpm.TPM2B_SENSITIVE_DATA;
import tss.tpm.TPM2B_SYM_KEY;
import tss.tpm.TPMU_SENSITIVE_COMPOSITE;
import tss.tpm.TPM_ALG_ID;

public class TPMT_SENSITIVE
extends TpmStructure {
    public byte[] authValue;
    public byte[] seedValue;
    public TPMU_SENSITIVE_COMPOSITE sensitive;

    public TPMT_SENSITIVE(byte[] _authValue, byte[] _seedValue, TPMU_SENSITIVE_COMPOSITE _sensitive) {
        this.authValue = _authValue;
        this.seedValue = _seedValue;
        this.sensitive = _sensitive;
    }

    public TPMT_SENSITIVE() {
    }

    public int GetUnionSelector_sensitive() {
        if (this.sensitive instanceof TPM2B_PRIVATE_KEY_RSA) {
            return 1;
        }
        if (this.sensitive instanceof TPM2B_ECC_PARAMETER) {
            return 35;
        }
        if (this.sensitive instanceof TPM2B_SENSITIVE_DATA) {
            return 8;
        }
        if (this.sensitive instanceof TPM2B_SYM_KEY) {
            return 37;
        }
        if (this.sensitive instanceof TPM2B_PRIVATE_VENDOR_SPECIFIC) {
            return Short.MAX_VALUE;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.GetUnionSelector_sensitive(), 2);
        buf.writeInt(this.authValue != null ? this.authValue.length : 0, 2);
        buf.write(this.authValue);
        buf.writeInt(this.seedValue != null ? this.seedValue.length : 0, 2);
        buf.write(this.seedValue);
        this.sensitive.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _sensitiveType = buf.readInt(2);
        int _authValueSize = buf.readInt(2);
        this.authValue = new byte[_authValueSize];
        buf.readArrayOfInts(this.authValue, 1, _authValueSize);
        int _seedValueSize = buf.readInt(2);
        this.seedValue = new byte[_seedValueSize];
        buf.readArrayOfInts(this.seedValue, 1, _seedValueSize);
        this.sensitive = null;
        if (_sensitiveType == TPM_ALG_ID.RSA.toInt()) {
            this.sensitive = new TPM2B_PRIVATE_KEY_RSA();
        } else if (_sensitiveType == TPM_ALG_ID.ECC.toInt()) {
            this.sensitive = new TPM2B_ECC_PARAMETER();
        } else if (_sensitiveType == TPM_ALG_ID.KEYEDHASH.toInt()) {
            this.sensitive = new TPM2B_SENSITIVE_DATA();
        } else if (_sensitiveType == TPM_ALG_ID.SYMCIPHER.toInt()) {
            this.sensitive = new TPM2B_SYM_KEY();
        } else if (_sensitiveType == TPM_ALG_ID.ANY.toInt()) {
            this.sensitive = new TPM2B_PRIVATE_VENDOR_SPECIFIC();
        }
        if (this.sensitive == null) {
            throw new RuntimeException("Unexpected type selector");
        }
        this.sensitive.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMT_SENSITIVE fromTpm(byte[] x) {
        TPMT_SENSITIVE ret = new TPMT_SENSITIVE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMT_SENSITIVE fromTpm(InByteBuf buf) {
        TPMT_SENSITIVE ret = new TPMT_SENSITIVE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMT_SENSITIVE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "authValue", this.authValue);
        _p.add(d, "byte", "seedValue", this.seedValue);
        _p.add(d, "TPMU_SENSITIVE_COMPOSITE", "sensitive", this.sensitive);
    }
}

