/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.io.IOException;
import java.net.Socket;
import tss.Helpers;
import tss.TpmDeviceBase;
import tss.TpmException;

public class TpmDeviceTcp
extends TpmDeviceBase {
    protected Socket CommandSocket = null;
    protected Socket SignalSocket = null;
    boolean linuxTrm;
    boolean oldTrm;
    boolean responsePending;
    int currentLocality;

    public TpmDeviceTcp(String hostName, int port) {
        this.linuxTrm = false;
        this.connect(hostName, port);
    }

    public TpmDeviceTcp(String hostName, int port, boolean linuxTrm) {
        this.linuxTrm = linuxTrm;
        this.oldTrm = true;
        this.connect(hostName, port);
    }

    private void connect(String hostName, int port) {
        try {
            this.CommandSocket = new Socket(hostName, port);
            if (!this.linuxTrm) {
                this.SignalSocket = new Socket(hostName, port + 1);
            }
        }
        catch (Exception e) {
            if (this.CommandSocket != null) {
                try {
                    this.CommandSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new TpmException("Failed to connect to the TPM at " + hostName + ":" + Integer.toString(port) + "/" + Integer.toString(port + 1), e);
        }
        if (this.linuxTrm) {
            byte[] byArray = new byte[12];
            byArray[0] = -128;
            byArray[1] = 1;
            byArray[5] = 12;
            byArray[8] = 1;
            byArray[9] = 123;
            byArray[11] = 8;
            byte[] cmdGetRandom = byArray;
            byte[] resp = null;
            try {
                this.dispatchCommand(cmdGetRandom);
                resp = this.getResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resp == null || resp.length != 20) {
                try {
                    this.CommandSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.oldTrm) {
                    this.oldTrm = false;
                    this.connect(hostName, port);
                } else {
                    throw new TpmException("Unknown user mode TRM protocol version");
                }
            }
        }
    }

    @Override
    public void dispatchCommand(byte[] commandBuffer) {
        this.writeInt(this.CommandSocket, TcpTpmCommands.SendCommand.Val);
        this.writeBuf(this.CommandSocket, new byte[]{(byte)this.currentLocality});
        if (this.linuxTrm && this.oldTrm) {
            this.writeBuf(this.CommandSocket, new byte[1]);
            this.writeBuf(this.CommandSocket, new byte[]{1});
        }
        this.writeInt(this.CommandSocket, commandBuffer.length);
        try {
            this.CommandSocket.getOutputStream().write(commandBuffer);
            this.responsePending = true;
        }
        catch (IOException e) {
            throw new TpmException("Error sending data to the TPM", e);
        }
    }

    @Override
    public byte[] getResponse() {
        if (!this.responsePending) {
            throw new TpmException("Cannot getResponse() without a prior dispatchCommand()");
        }
        this.responsePending = false;
        byte[] outBuf = this.readEncapsulated(this.CommandSocket);
        this.readInt(this.CommandSocket);
        return outBuf;
    }

    @Override
    public boolean responseReady() {
        int available;
        if (!this.responsePending) {
            throw new TpmException("Cannot responseReady() without a prior dispatchCommand()");
        }
        try {
            available = this.CommandSocket.getInputStream().available();
        }
        catch (IOException e) {
            throw new TpmException("Error getting data from the TPM", e);
        }
        return available > 0;
    }

    @Override
    public void powerCycle() {
        this.powerOff();
        this.powerOn();
    }

    @Override
    public void powerOff() {
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalPowerOff);
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalNvOff);
    }

    @Override
    public void powerOn() {
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalPowerOn);
        this.sendCmdAndGetAck(this.SignalSocket, TcpTpmCommands.SignalNvOn);
    }

    @Override
    public void setLocality(int locality) {
        this.currentLocality = locality;
    }

    public void sendCmdAndGetAck(Socket s, TcpTpmCommands comm) {
        this.writeEncapsulated(s, Helpers.hostToNet(comm.getVal()));
        this.getAck(s);
    }

    private void getAck(Socket s) {
        this.readInt(s);
    }

    private int readInt(Socket s) {
        int val = -1;
        try {
            val = Helpers.netToHost(this.readBuf(s, 4));
        }
        catch (Exception e) {
            throw new TpmException("TPM IO error", e);
        }
        return val;
    }

    private void writeInt(Socket s, int val) {
        this.writeBuf(s, Helpers.hostToNet(val));
    }

    private void writeBuf(Socket s, byte[] buffer) {
        try {
            s.getOutputStream().write(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            throw new TpmException("TPM IO error", e);
        }
    }

    private byte[] readBuf(Socket s, int numBytes) {
        byte[] buf = new byte[numBytes];
        int numRead = 0;
        while (numRead < numBytes) {
            int sz;
            try {
                sz = s.getInputStream().read(buf, numRead, numBytes - numRead);
            }
            catch (IOException e) {
                throw new TpmException("TPM IO error", e);
            }
            numRead += sz;
        }
        return buf;
    }

    private void writeEncapsulated(Socket s, byte[] buf) {
        this.writeBuf(s, Helpers.hostToNet(buf.length));
        this.writeBuf(s, buf);
    }

    private byte[] readEncapsulated(Socket s) {
        byte[] t = this.readBuf(s, 4);
        int sz = Helpers.netToHost(t);
        return this.readBuf(s, sz);
    }

    @Override
    public void close() throws IOException {
        if (this.CommandSocket != null) {
            this.writeInt(this.CommandSocket, TcpTpmCommands.SessionEnd.Val);
            this.CommandSocket.close();
            this.CommandSocket = null;
        }
        if (this.SignalSocket != null) {
            this.writeInt(this.SignalSocket, TcpTpmCommands.SessionEnd.Val);
            this.SignalSocket.close();
            this.SignalSocket = null;
        }
    }

    static enum TcpTpmCommands {
        SignalPowerOn(1),
        SignalPowerOff(2),
        SignalPPOn(3),
        SignalPPOff(4),
        SignalHashStart(5),
        SignalHashData(6),
        SignalHashEnd(7),
        SendCommand(8),
        SignalCancelOn(9),
        SignalCancelOff(10),
        SignalNvOn(11),
        SignalNvOff(12),
        SignalKeyCacheOn(13),
        SignalKeyCacheOff(14),
        RemoteHandshake(15),
        SessionEnd(20),
        Stop(21),
        TestFailureMode(30);

        private int Val;

        private TcpTpmCommands(int val) {
            this.setVal(val);
        }

        public int getVal() {
            return this.Val;
        }

        public void setVal(int val) {
            this.Val = val;
        }
    }
}

