/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class StartAuthSessionResponse
extends TpmStructure {
    public TPM_HANDLE handle;
    public byte[] nonceTPM;

    public StartAuthSessionResponse(TPM_HANDLE _handle, byte[] _nonceTPM) {
        this.handle = _handle;
        this.nonceTPM = _nonceTPM;
    }

    public StartAuthSessionResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.handle.toTpm(buf);
        buf.writeInt(this.nonceTPM != null ? this.nonceTPM.length : 0, 2);
        if (this.nonceTPM != null) {
            buf.write(this.nonceTPM);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = TPM_HANDLE.fromTpm(buf);
        int _nonceTPMSize = buf.readInt(2);
        this.nonceTPM = new byte[_nonceTPMSize];
        buf.readArrayOfInts(this.nonceTPM, 1, _nonceTPMSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static StartAuthSessionResponse fromTpm(byte[] x) {
        StartAuthSessionResponse ret = new StartAuthSessionResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static StartAuthSessionResponse fromTpm(InByteBuf buf) {
        StartAuthSessionResponse ret = new StartAuthSessionResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_StartAuthSession_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "handle", this.handle);
        _p.add(d, "byte", "nonceTPM", this.nonceTPM);
    }
}

