/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_EncryptDecrypt2_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyHandle;
    public byte[] inData;
    public byte decrypt;
    public TPM_ALG_ID mode;
    public byte[] ivIn;

    public TPM2_EncryptDecrypt2_REQUEST(TPM_HANDLE _keyHandle, byte[] _inData, byte _decrypt, TPM_ALG_ID _mode, byte[] _ivIn) {
        this.keyHandle = _keyHandle;
        this.inData = _inData;
        this.decrypt = _decrypt;
        this.mode = _mode;
        this.ivIn = _ivIn;
    }

    public TPM2_EncryptDecrypt2_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.inData != null ? this.inData.length : 0, 2);
        if (this.inData != null) {
            buf.write(this.inData);
        }
        buf.write(this.decrypt);
        this.mode.toTpm(buf);
        buf.writeInt(this.ivIn != null ? this.ivIn.length : 0, 2);
        if (this.ivIn != null) {
            buf.write(this.ivIn);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _inDataSize = buf.readInt(2);
        this.inData = new byte[_inDataSize];
        buf.readArrayOfInts(this.inData, 1, _inDataSize);
        this.decrypt = (byte)buf.readInt(1);
        this.mode = TPM_ALG_ID.fromTpm(buf);
        int _ivInSize = buf.readInt(2);
        this.ivIn = new byte[_ivInSize];
        buf.readArrayOfInts(this.ivIn, 1, _ivInSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_EncryptDecrypt2_REQUEST fromTpm(byte[] x) {
        TPM2_EncryptDecrypt2_REQUEST ret = new TPM2_EncryptDecrypt2_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_EncryptDecrypt2_REQUEST fromTpm(InByteBuf buf) {
        TPM2_EncryptDecrypt2_REQUEST ret = new TPM2_EncryptDecrypt2_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_EncryptDecrypt2_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "inData", this.inData);
        _p.add(d, "BYTE", "decrypt", this.decrypt);
        _p.add(d, "TPM_ALG_ID", "mode", this.mode);
        _p.add(d, "byte", "ivIn", this.ivIn);
    }
}

