/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_EventSequenceComplete_REQUEST
extends TpmStructure {
    public TPM_HANDLE pcrHandle;
    public TPM_HANDLE sequenceHandle;
    public byte[] buffer;

    public TPM2_EventSequenceComplete_REQUEST(TPM_HANDLE _pcrHandle, TPM_HANDLE _sequenceHandle, byte[] _buffer) {
        this.pcrHandle = _pcrHandle;
        this.sequenceHandle = _sequenceHandle;
        this.buffer = _buffer;
    }

    public TPM2_EventSequenceComplete_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.pcrHandle.toTpm(buf);
        this.sequenceHandle.toTpm(buf);
        buf.writeInt(this.buffer != null ? this.buffer.length : 0, 2);
        if (this.buffer != null) {
            buf.write(this.buffer);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.pcrHandle = TPM_HANDLE.fromTpm(buf);
        this.sequenceHandle = TPM_HANDLE.fromTpm(buf);
        int _bufferSize = buf.readInt(2);
        this.buffer = new byte[_bufferSize];
        buf.readArrayOfInts(this.buffer, 1, _bufferSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_EventSequenceComplete_REQUEST fromTpm(byte[] x) {
        TPM2_EventSequenceComplete_REQUEST ret = new TPM2_EventSequenceComplete_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_EventSequenceComplete_REQUEST fromTpm(InByteBuf buf) {
        TPM2_EventSequenceComplete_REQUEST ret = new TPM2_EventSequenceComplete_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_EventSequenceComplete_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "pcrHandle", this.pcrHandle);
        _p.add(d, "TPM_HANDLE", "sequenceHandle", this.sequenceHandle);
        _p.add(d, "byte", "buffer", this.buffer);
    }
}

