/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HANDLE;

public class TPM2_ObjectChangeAuth_REQUEST
extends TpmStructure {
    public TPM_HANDLE objectHandle;
    public TPM_HANDLE parentHandle;
    public byte[] newAuth;

    public TPM2_ObjectChangeAuth_REQUEST(TPM_HANDLE _objectHandle, TPM_HANDLE _parentHandle, byte[] _newAuth) {
        this.objectHandle = _objectHandle;
        this.parentHandle = _parentHandle;
        this.newAuth = _newAuth;
    }

    public TPM2_ObjectChangeAuth_REQUEST() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.objectHandle.toTpm(buf);
        this.parentHandle.toTpm(buf);
        buf.writeInt(this.newAuth != null ? this.newAuth.length : 0, 2);
        if (this.newAuth != null) {
            buf.write(this.newAuth);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.objectHandle = TPM_HANDLE.fromTpm(buf);
        this.parentHandle = TPM_HANDLE.fromTpm(buf);
        int _newAuthSize = buf.readInt(2);
        this.newAuth = new byte[_newAuthSize];
        buf.readArrayOfInts(this.newAuth, 1, _newAuthSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_ObjectChangeAuth_REQUEST fromTpm(byte[] x) {
        TPM2_ObjectChangeAuth_REQUEST ret = new TPM2_ObjectChangeAuth_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_ObjectChangeAuth_REQUEST fromTpm(InByteBuf buf) {
        TPM2_ObjectChangeAuth_REQUEST ret = new TPM2_ObjectChangeAuth_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ObjectChangeAuth_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "objectHandle", this.objectHandle);
        _p.add(d, "TPM_HANDLE", "parentHandle", this.parentHandle);
        _p.add(d, "byte", "newAuth", this.newAuth);
    }
}

