/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_NULL_SIGNATURE;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SIGNATURE_ECDAA;
import tss.tpm.TPMS_SIGNATURE_ECDSA;
import tss.tpm.TPMS_SIGNATURE_ECSCHNORR;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIGNATURE_SM2;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;

public class TPM2_VerifySignature_REQUEST
extends TpmStructure {
    public TPM_HANDLE keyHandle;
    public byte[] digest;
    public TPMU_SIGNATURE signature;

    public TPM2_VerifySignature_REQUEST(TPM_HANDLE _keyHandle, byte[] _digest, TPMU_SIGNATURE _signature) {
        this.keyHandle = _keyHandle;
        this.digest = _digest;
        this.signature = _signature;
    }

    public TPM2_VerifySignature_REQUEST() {
    }

    public int GetUnionSelector_signature() {
        if (this.signature instanceof TPMS_SIGNATURE_RSASSA) {
            return 20;
        }
        if (this.signature instanceof TPMS_SIGNATURE_RSAPSS) {
            return 22;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECDSA) {
            return 24;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECDAA) {
            return 26;
        }
        if (this.signature instanceof TPMS_SIGNATURE_SM2) {
            return 27;
        }
        if (this.signature instanceof TPMS_SIGNATURE_ECSCHNORR) {
            return 28;
        }
        if (this.signature instanceof TPMT_HA) {
            return 5;
        }
        if (this.signature instanceof TPMS_SCHEME_HASH) {
            return Short.MAX_VALUE;
        }
        if (this.signature instanceof TPMS_NULL_SIGNATURE) {
            return 16;
        }
        throw new RuntimeException("Unrecognized type");
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.keyHandle.toTpm(buf);
        buf.writeInt(this.digest != null ? this.digest.length : 0, 2);
        if (this.digest != null) {
            buf.write(this.digest);
        }
        buf.writeInt(this.GetUnionSelector_signature(), 2);
        this.signature.toTpm(buf);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.keyHandle = TPM_HANDLE.fromTpm(buf);
        int _digestSize = buf.readInt(2);
        this.digest = new byte[_digestSize];
        buf.readArrayOfInts(this.digest, 1, _digestSize);
        int _signatureSigAlg = buf.readInt(2);
        this.signature = null;
        if (_signatureSigAlg == TPM_ALG_ID.RSASSA.toInt()) {
            this.signature = new TPMS_SIGNATURE_RSASSA();
        } else if (_signatureSigAlg == TPM_ALG_ID.RSAPSS.toInt()) {
            this.signature = new TPMS_SIGNATURE_RSAPSS();
        } else if (_signatureSigAlg == TPM_ALG_ID.ECDSA.toInt()) {
            this.signature = new TPMS_SIGNATURE_ECDSA();
        } else if (_signatureSigAlg == TPM_ALG_ID.ECDAA.toInt()) {
            this.signature = new TPMS_SIGNATURE_ECDAA();
        } else if (_signatureSigAlg == TPM_ALG_ID.ANY.toInt()) {
            this.signature = new TPMS_SCHEME_HASH();
        } else if (_signatureSigAlg == TPM_ALG_ID.NULL.toInt()) {
            this.signature = new TPMS_NULL_SIGNATURE();
        }
        if (this.signature == null) {
            throw new RuntimeException("Unexpected type selector " + TPM_ALG_ID.fromInt(_signatureSigAlg).name());
        }
        this.signature.initFromTpm(buf);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM2_VerifySignature_REQUEST fromTpm(byte[] x) {
        TPM2_VerifySignature_REQUEST ret = new TPM2_VerifySignature_REQUEST();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM2_VerifySignature_REQUEST fromTpm(InByteBuf buf) {
        TPM2_VerifySignature_REQUEST ret = new TPM2_VerifySignature_REQUEST();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_VerifySignature_REQUEST");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_HANDLE", "keyHandle", this.keyHandle);
        _p.add(d, "byte", "digest", this.digest);
        _p.add(d, "TPMU_SIGNATURE", "signature", this.signature);
    }
}

