/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class TPMS_SIGNATURE_ECSCHNORR
extends TpmStructure
implements TPMU_SIGNATURE {
    public TPM_ALG_ID hash;
    public byte[] signatureR;
    public byte[] signatureS;

    public TPMS_SIGNATURE_ECSCHNORR(TPM_ALG_ID _hash, byte[] _signatureR, byte[] _signatureS) {
        this.hash = _hash;
        this.signatureR = _signatureR;
        this.signatureS = _signatureS;
    }

    public TPMS_SIGNATURE_ECSCHNORR() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        this.hash.toTpm(buf);
        buf.writeInt(this.signatureR != null ? this.signatureR.length : 0, 2);
        if (this.signatureR != null) {
            buf.write(this.signatureR);
        }
        buf.writeInt(this.signatureS != null ? this.signatureS.length : 0, 2);
        if (this.signatureS != null) {
            buf.write(this.signatureS);
        }
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.hash = TPM_ALG_ID.fromTpm(buf);
        int _signatureRSize = buf.readInt(2);
        this.signatureR = new byte[_signatureRSize];
        buf.readArrayOfInts(this.signatureR, 1, _signatureRSize);
        int _signatureSSize = buf.readInt(2);
        this.signatureS = new byte[_signatureSSize];
        buf.readArrayOfInts(this.signatureS, 1, _signatureSSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPMS_SIGNATURE_ECSCHNORR fromTpm(byte[] x) {
        TPMS_SIGNATURE_ECSCHNORR ret = new TPMS_SIGNATURE_ECSCHNORR();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPMS_SIGNATURE_ECSCHNORR fromTpm(InByteBuf buf) {
        TPMS_SIGNATURE_ECSCHNORR ret = new TPMS_SIGNATURE_ECSCHNORR();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPMS_SIGNATURE_ECSCHNORR");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPM_ALG_ID", "hash", this.hash);
        _p.add(d, "byte", "signatureR", this.signatureR);
        _p.add(d, "byte", "signatureS", this.signatureS);
    }
}

