/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.Helpers;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM_HT;
import tss.tpm.TPM_RH;

public class TPM_HANDLE
extends TpmStructure {
    public int handle;
    public static final TPM_HANDLE NULL = TPM_HANDLE.from(TPM_RH.NULL);
    public byte[] AuthValue;
    public byte[] Name;

    public TPM_HANDLE(int _handle) {
        this.handle = _handle;
    }

    public TPM_HANDLE() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.write(this.handle);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        this.handle = buf.readInt(4);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static TPM_HANDLE fromTpm(byte[] x) {
        TPM_HANDLE ret = new TPM_HANDLE();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static TPM_HANDLE fromTpm(InByteBuf buf) {
        TPM_HANDLE ret = new TPM_HANDLE();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM_HANDLE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "uint", "handle", this.handle);
    }

    public static TPM_HANDLE from(int val) {
        return new TPM_HANDLE(val);
    }

    public static TPM_HANDLE from(TPM_RH _handle) {
        return new TPM_HANDLE(_handle.toInt());
    }

    public static TPM_HANDLE nullHandle() {
        return new TPM_HANDLE(TPM_RH.NULL.toInt());
    }

    public static TPM_HANDLE persistent(int handleOffset) {
        return new TPM_HANDLE((TPM_HT.PERSISTENT.toInt() << 24) + handleOffset);
    }

    public static TPM_HANDLE pcr(int PcrIndex) {
        return new TPM_HANDLE(PcrIndex);
    }

    public TPM_HT getType() {
        return TPM_HT.fromInt(this.handle >> 24);
    }

    public static TPM_HANDLE NV(int NvSlot) {
        int handleVal = (TPM_HT.NV_INDEX.toInt() << 24) + NvSlot;
        return new TPM_HANDLE(handleVal);
    }

    public static TPM_HANDLE pwSession(byte[] authValue) {
        TPM_HANDLE pwapHandle = TPM_HANDLE.from(TPM_RH.RS_PW);
        pwapHandle.AuthValue = authValue;
        return pwapHandle;
    }

    public byte[] getName() {
        int handleType = this.getType().toInt();
        switch (handleType) {
            case 0: 
            case 2: 
            case 3: 
            case 64: {
                this.Name = Helpers.hostToNet(this.handle);
                return this.Name;
            }
            case 1: 
            case 128: 
            case 129: {
                if (this.Name.length == 0) {
                    throw new RuntimeException("Name is not set for handle");
                }
                return this.Name;
            }
        }
        throw new RuntimeException("Unknown handle type");
    }
}

