/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.cache.redis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mpush.cache.redis.RedisServer;
import com.mpush.tools.Jsons;
import com.mpush.tools.config.CC;
import com.mpush.tools.log.Logs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.util.Pool;

public final class RedisClient {
    public static final JedisPoolConfig CONFIG = RedisClient.buildConfig();
    private static final Map<RedisServer, JedisPool> POOL_MAP = Maps.newConcurrentMap();

    private static JedisPoolConfig buildConfig() {
        JedisPoolConfig config2 = new JedisPoolConfig();
        config2.setMaxTotal(CC.mp.redis.config.maxTotal);
        config2.setMaxIdle(CC.mp.redis.config.maxIdle);
        config2.setMinIdle(CC.mp.redis.config.minIdle);
        config2.setMaxWaitMillis(CC.mp.redis.config.maxWaitMillis);
        config2.setMinEvictableIdleTimeMillis(CC.mp.redis.config.minEvictableIdleTimeMillis);
        config2.setNumTestsPerEvictionRun(CC.mp.redis.config.numTestsPerEvictionRun);
        config2.setTimeBetweenEvictionRunsMillis(CC.mp.redis.config.timeBetweenEvictionRunsMillis);
        config2.setTestOnBorrow(CC.mp.redis.config.testOnBorrow);
        config2.setTestOnReturn(CC.mp.redis.config.testOnReturn);
        config2.setTestWhileIdle(CC.mp.redis.config.testWhileIdle);
        return config2;
    }

    public static Jedis getClient(RedisServer node) {
        JedisPool pool = POOL_MAP.get((Object)node);
        if (pool == null) {
            pool = new JedisPool((GenericObjectPoolConfig)CONFIG, node.getHost(), node.getPort(), 2000, node.getPassword());
            POOL_MAP.put(node, pool);
        }
        return pool.getResource();
    }

    public static void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incr(List<RedisServer> nodeList, String key, Integer time) {
        long incrRet = -1L;
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                long ret = jedis.incr(key);
                if (ret == 1L && time != null) {
                    jedis.expire(key, time.intValue());
                }
                incrRet = ret;
            }
            catch (Exception e) {
                Logs.REDIS.error("redis incr exception:{}, {}, {}, {}", new Object[]{key, time, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
        return incrRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrBy(List<RedisServer> nodeList, String key, long delt) {
        long incrRet = -1L;
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                long ret;
                jedis = RedisClient.getClient(node);
                incrRet = ret = jedis.incrBy(key, delt).longValue();
            }
            catch (Exception e) {
                Logs.REDIS.error("redis incr exception:{}, {}, {}, {}", new Object[]{key, delt, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
        return incrRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(RedisServer node, String key, Class<T> clazz) {
        String value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.get(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis get exception:{}, {}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        if (clazz == String.class) {
            return (T)value;
        }
        return (T)Jsons.fromJson((String)value, clazz);
    }

    public static void set(List<RedisServer> nodeList, String key, String value) {
        RedisClient.set(nodeList, key, value, null);
    }

    public static <T> void set(List<RedisServer> nodeList, String key, T value) {
        RedisClient.set(nodeList, key, value, null);
    }

    public static <T> void set(List<RedisServer> nodeList, String key, T value, Integer time) {
        String jsonValue = Jsons.toJson(value);
        RedisClient.set(nodeList, key, jsonValue, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(List<RedisServer> nodeList, String key, String value, Integer time) {
        if (time == null) {
            time = -1;
        }
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.set(key, value);
                if (time <= 0) continue;
                jedis.expire(key, time.intValue());
            }
            catch (Exception e) {
                Logs.REDIS.error("redis set exception:{}, {}, {}, {}", new Object[]{key, value, time, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void del(List<RedisServer> nodeList, String key) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.del(key);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis del exception:{}, {}", new Object[]{key, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hset(List<RedisServer> nodeList, String key, String field, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.hset(key, field, value);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis hset exception:{}, {}, {}, {}", new Object[]{key, field, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    public static <T> void hset(List<RedisServer> nodeList, String key, String field, T value) {
        RedisClient.hset(nodeList, key, field, Jsons.toJson(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T hget(RedisServer node, String key, String field, Class<T> clazz) {
        String value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.hget(key, field);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis hget exception:{}, {}", new Object[]{key, field, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return (T)Jsons.fromJson((String)value, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hdel(List<RedisServer> nodeList, String key, String field) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.hdel(key, new String[]{field});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis hdel exception:{}, {}, {}", new Object[]{key, field, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> hgetAll(RedisServer node, String key) {
        Map result = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            result = jedis.hgetAll(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis hgetAll exception:{}, {}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return result;
    }

    public static <T> Map<String, T> hgetAll(RedisServer node, String key, Class<T> clazz) {
        Map<String, String> result = RedisClient.hgetAll(node, key);
        if (result != null) {
            HashMap newMap = Maps.newHashMap();
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                newMap.put(k, Jsons.fromJson((String)v, clazz));
            }
            return newMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> hkeys(RedisServer node, String key) {
        Set result = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            result = jedis.hkeys(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis hkeys exception:{},{}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> hmget(RedisServer node, String key, Class<T> clazz, String ... fields) {
        List value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.hmget(key, fields);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis hmget exception:{},{},{}", new Object[]{key, fields, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return RedisClient.toList(value, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hmset(List<RedisServer> nodeList, String key, Map<String, String> hash, Integer time) {
        if (time == null) {
            time = -1;
        }
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.hmset(key, hash);
                if (time <= 0) continue;
                jedis.expire(key, time.intValue());
            }
            catch (Exception e) {
                Logs.REDIS.error("redis hmset exception:{},{},{}", new Object[]{key, time, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    public static void hmset(List<RedisServer> nodeList, String key, Map<String, String> hash) {
        RedisClient.hmset(nodeList, key, hash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lpush(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.lpush(key, new String[]{value});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis lpush exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    public static <T> void lpush(List<RedisServer> nodeList, String key, T value) {
        RedisClient.lpush(nodeList, key, Jsons.toJson(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rpush(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.rpush(key, new String[]{value});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis rpush exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    public static <T> void rpush(List<RedisServer> nodeList, String key, T value) {
        RedisClient.rpush(nodeList, key, Jsons.toJson(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lpop(List<RedisServer> nodeList, String key, Class<T> clazz) {
        String retValue = null;
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            String vaule = null;
            try {
                jedis = RedisClient.getClient(node);
                retValue = vaule = jedis.lpop(key);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis lpop exception:{},{}", new Object[]{key, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
        return (T)Jsons.fromJson(retValue, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T rpop(List<RedisServer> nodeList, String key, Class<T> clazz) {
        String retValue = null;
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            String vaule = null;
            try {
                jedis = RedisClient.getClient(node);
                retValue = vaule = jedis.rpop(key);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis rpop exception:{},{}", new Object[]{key, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
        return (T)Jsons.fromJson(retValue, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> lrange(RedisServer node, String key, int start, int end, Class<T> clazz) {
        List value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.lrange(key, (long)start, (long)end);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis lrange exception:{},{},{},{}", new Object[]{key, start, end, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return RedisClient.toList(value, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long llen(RedisServer node, String key) {
        long len = 0L;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            len = jedis.llen(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis llen exception:{},{}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lRem(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.lrem(key, 0L, value);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis lrem exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void publish(RedisServer node, String channel, T message) {
        Jedis jedis = null;
        String value = null;
        value = message instanceof String ? (String)message : Jsons.toJson(message);
        try {
            jedis = RedisClient.getClient(node);
            jedis.publish(channel, value);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis publish exception:{},{},{}", new Object[]{value, Jsons.toJson((Object)((Object)node)), Jsons.toJson((Object)channel), e});
        }
        finally {
            RedisClient.close(jedis);
        }
    }

    public static void subscribe(Set<RedisServer> nodeList, final JedisPubSub pubsub, final String ... channels) {
        for (final RedisServer node : nodeList) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RedisClient.subscribe(node, pubsub, channels);
                }
            }, node.getHost() + "_" + Jsons.toJson((Object)channels)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subscribe(RedisServer node, JedisPubSub pubsub, String ... channel) {
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            jedis.subscribe(pubsub, channel);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis subscribe exception:{},{}", new Object[]{Jsons.toJson((Object)((Object)node)), Jsons.toJson((Object)channel), e});
        }
        finally {
            RedisClient.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sAdd(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.sadd(key, new String[]{value});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis sadd exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long sCard(RedisServer node, String key) {
        Long value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.scard(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis scard exception:{},{}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sRem(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.srem(key, new String[]{value});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis srem exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> sScan(RedisServer node, String key, Class<T> clazz, int start) {
        List value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            ScanResult sscanResult = jedis.sscan(key, start + "", new ScanParams().count(Integer.valueOf(10)));
            if (sscanResult != null && sscanResult.getResult() != null) {
                value = sscanResult.getResult();
            }
        }
        catch (Exception e) {
            Logs.REDIS.error("redis sscan exception:{},{},{}", new Object[]{key, start, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return RedisClient.toList(value, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zAdd(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.zadd(key, 0.0, value);
            }
            catch (Exception e) {
                Logs.REDIS.error("redis zadd exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long zCard(RedisServer node, String key) {
        Long value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.zcard(key);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis zcard exception:{},{}", new Object[]{key, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zRem(List<RedisServer> nodeList, String key, String value) {
        for (RedisServer node : nodeList) {
            Jedis jedis = null;
            try {
                jedis = RedisClient.getClient(node);
                jedis.zrem(key, new String[]{value});
            }
            catch (Exception e) {
                Logs.REDIS.error("redis srem exception:{},{},{}", new Object[]{key, value, node, e});
            }
            finally {
                RedisClient.close(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> zrange(RedisServer node, String key, int start, int end, Class<T> clazz) {
        Set value = null;
        Jedis jedis = null;
        try {
            jedis = RedisClient.getClient(node);
            value = jedis.zrange(key, (long)start, (long)end);
        }
        catch (Exception e) {
            Logs.REDIS.error("redis zrange exception:{},{},{},{}", new Object[]{key, start, end, node, e});
        }
        finally {
            RedisClient.close(jedis);
        }
        return RedisClient.toList(value, clazz);
    }

    private static <T> List<T> toList(Collection<String> value, Class<T> clazz) {
        if (value != null) {
            ArrayList newValue = Lists.newArrayList();
            for (String temp : value) {
                newValue.add(Jsons.fromJson((String)temp, clazz));
            }
            return newValue;
        }
        return null;
    }

    public static void destroy() {
        POOL_MAP.values().forEach(Pool::close);
    }
}

