/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.cache.redis.hash;

import com.mpush.cache.redis.hash.Node;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import redis.clients.util.Hashing;

public class ConsistentHash {
    private final Hashing hash;
    private final int numberOfReplicas;
    private final SortedMap<Long, Node> circle = new TreeMap<Long, Node>();

    public ConsistentHash(Hashing hash, int numberOfReplicas, Collection<Node> nodes) {
        this.hash = hash;
        this.numberOfReplicas = numberOfReplicas;
        for (Node node : nodes) {
            this.add(node);
        }
    }

    public void add(Node node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hash.hash(node.toString() + i), node);
        }
    }

    public void remove(String node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hash.hash(node.toString() + i));
        }
    }

    public Node get(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hash.hash(key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Long, Node> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        return (Node)this.circle.get(hash);
    }
}

