/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.cache.redis.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mpush.cache.redis.listener.MessageListener;
import com.mpush.cache.redis.manager.RedisManager;
import com.mpush.cache.redis.mq.Subscriber;
import com.mpush.tools.log.Logs;
import com.mpush.tools.thread.pool.ThreadPoolManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ListenerDispatcher
implements MessageListener {
    public static final ListenerDispatcher I = new ListenerDispatcher();
    private final Map<String, List<MessageListener>> subscribes = Maps.newTreeMap();
    private final Executor executor = ThreadPoolManager.I.getRedisExecutor();

    private ListenerDispatcher() {
    }

    @Override
    public void onMessage(String channel, String message) {
        List<MessageListener> listeners = this.subscribes.get(channel);
        if (listeners == null) {
            Logs.REDIS.info("cannot find listener:%s,%s", (Object)channel, (Object)message);
            return;
        }
        for (MessageListener listener : listeners) {
            this.executor.execute(() -> listener.onMessage(channel, message));
        }
    }

    public void subscribe(String channel, MessageListener listener) {
        ArrayList listeners = this.subscribes.get(channel);
        if (listeners == null) {
            listeners = Lists.newArrayList();
            this.subscribes.put(channel, listeners);
        }
        listeners.add(listener);
        RedisManager.I.subscribe(Subscriber.holder, channel);
    }
}

