/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.cache.redis.manager;

import com.google.common.collect.Sets;
import com.mpush.cache.redis.RedisClient;
import com.mpush.cache.redis.RedisGroup;
import com.mpush.cache.redis.RedisServer;
import com.mpush.cache.redis.manager.RedisClusterManager;
import com.mpush.cache.redis.manager.ZKRedisClusterManager;
import com.mpush.tools.Jsons;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public final class RedisManager {
    public static final RedisManager I = new RedisManager();
    private final RedisClusterManager clusterManager = ZKRedisClusterManager.I;

    public void init() {
        ZKRedisClusterManager.I.init();
        this.test(this.clusterManager.getGroupList());
    }

    public long incr(String key, Integer time) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        return RedisClient.incr(nodeList, key, time);
    }

    public long incrBy(String key, long delt) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        return RedisClient.incrBy(nodeList, key, delt);
    }

    public <T> T get(String key, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.get(node, key, clazz);
    }

    public <T> void set(String key, T value) {
        this.set(key, value, null);
    }

    public <T> void set(String key, T value, Integer time) {
        String jsonValue = Jsons.toJson(value);
        this.set(key, jsonValue, time);
    }

    public void set(String key, String value, Integer time) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.set(nodeList, key, value, time);
    }

    public void del(String key) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.del(nodeList, key);
    }

    public void hset(String key, String field, String value) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(field);
        RedisClient.hset(nodeList, key, field, value);
    }

    public <T> void hset(String key, String field, T value) {
        this.hset(key, field, Jsons.toJson(value));
    }

    public <T> T hget(String key, String field, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.hget(node, key, field, clazz);
    }

    public void hdel(String key, String field) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.hdel(nodeList, key, field);
    }

    public Map<String, String> hgetAll(String key) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.hgetAll(node, key);
    }

    public <T> Map<String, T> hgetAll(String key, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.hgetAll(node, key, clazz);
    }

    public Set<String> hkeys(String key) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.hkeys(node, key);
    }

    public <T> List<T> hmget(String key, Class<T> clazz, String ... fields) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.hmget(node, key, clazz, fields);
    }

    public void hmset(String key, Map<String, String> hash, Integer time) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.hmset(nodeList, key, hash, time);
    }

    public void hmset(String key, Map<String, String> hash) {
        this.hmset(key, hash, null);
    }

    public void lpush(String key, String value) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.lpush(nodeList, key, value);
    }

    public <T> void lpush(String key, T value) {
        this.lpush(key, Jsons.toJson(value));
    }

    public void rpush(String key, String value) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.rpush(nodeList, key, value);
    }

    public <T> void rpush(String key, T value) {
        this.rpush(key, Jsons.toJson(value));
    }

    public <T> T lpop(String key, Class<T> clazz) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        return RedisClient.lpop(nodeList, key, clazz);
    }

    public <T> T rpop(String key, Class<T> clazz) {
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        return RedisClient.rpop(nodeList, key, clazz);
    }

    public <T> List<T> lrange(String key, int start, int end, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.lrange(node, key, start, end, clazz);
    }

    public long llen(String key) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.llen(node, key);
    }

    public <T> void lrem(String key, T value) {
        String jsonValue = Jsons.toJson(value);
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.lRem(nodeList, key, jsonValue);
    }

    public <T> void publish(String channel, T message) {
        RedisServer node = this.clusterManager.randomGetRedisNode(channel);
        RedisClient.publish(node, channel, message);
    }

    public void subscribe(JedisPubSub pubsub, String ... channels) {
        HashSet set = Sets.newHashSet();
        for (String channel : channels) {
            List<RedisServer> nodeList = this.clusterManager.hashSet(channel);
            set.addAll(nodeList);
        }
        RedisClient.subscribe(set, pubsub, channels);
    }

    public <T> void sAdd(String key, T value) {
        String jsonValue = Jsons.toJson(value);
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.sAdd(nodeList, key, jsonValue);
    }

    public Long sCard(String key) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.sCard(node, key);
    }

    public <T> void sRem(String key, T value) {
        String jsonValue = Jsons.toJson(value);
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.sRem(nodeList, key, jsonValue);
    }

    public <T> List<T> sScan(String key, int start, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.sScan(node, key, clazz, start);
    }

    public <T> void zAdd(String key, T value) {
        String jsonValue = Jsons.toJson(value);
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.zAdd(nodeList, key, jsonValue);
    }

    public Long zCard(String key) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.zCard(node, key);
    }

    public <T> void zRem(String key, T value) {
        String jsonValue = Jsons.toJson(value);
        List<RedisServer> nodeList = this.clusterManager.hashSet(key);
        RedisClient.zRem(nodeList, key, jsonValue);
    }

    public <T> List<T> zrange(String key, int start, int end, Class<T> clazz) {
        RedisServer node = this.clusterManager.randomGetRedisNode(key);
        return RedisClient.zrange(node, key, start, end, clazz);
    }

    public void test(List<RedisGroup> groupList) {
        if (groupList == null || groupList.isEmpty()) {
            throw new RuntimeException("init redis sever error.");
        }
        for (RedisGroup group : groupList) {
            List<RedisServer> list = group.getRedisServerList();
            if (list == null || list.isEmpty()) {
                throw new RuntimeException("init redis sever error.");
            }
            for (RedisServer node : list) {
                Jedis jedis = RedisClient.getClient(node);
                if (jedis == null) {
                    throw new RuntimeException("init redis sever error.");
                }
                jedis.close();
            }
        }
    }

    public void close() {
        RedisClient.destroy();
    }
}

