/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.cache.redis.manager;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mpush.cache.redis.RedisException;
import com.mpush.cache.redis.RedisGroup;
import com.mpush.cache.redis.RedisServer;
import com.mpush.cache.redis.manager.RedisClusterManager;
import com.mpush.tools.Jsons;
import com.mpush.tools.config.CC;
import com.mpush.tools.log.Logs;
import com.mpush.zk.ZKClient;
import com.mpush.zk.ZKPath;
import com.mpush.zk.listener.ZKRedisNodeWatcher;
import com.mpush.zk.node.ZKRedisNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ZKRedisClusterManager
implements RedisClusterManager {
    public static final ZKRedisClusterManager I = new ZKRedisClusterManager();
    private final List<RedisGroup> groups = new ArrayList<RedisGroup>();

    private ZKRedisClusterManager() {
    }

    @Override
    public void init() {
        Logs.Console.error("begin init redis cluster");
        if (!ZKClient.I.isRunning()) {
            throw new RedisException("init redis cluster ex, ZK client not running.");
        }
        List groupList = CC.mp.redis.cluster_group;
        if (groupList.size() > 0) {
            if (CC.mp.redis.write_to_zk) {
                this.register(groupList);
            } else if (!ZKClient.I.isExisted(ZKPath.REDIS_SERVER.getRootPath())) {
                this.register(groupList);
            } else if (Strings.isNullOrEmpty((String)ZKClient.I.get(ZKPath.REDIS_SERVER.getRootPath()))) {
                this.register(groupList);
            }
        }
        ZKRedisNodeWatcher watcher = new ZKRedisNodeWatcher();
        watcher.beginWatch();
        Collection nodes = watcher.getCache().values();
        if (nodes == null || nodes.isEmpty()) {
            Logs.REDIS.info("init redis client error, redis server is none.");
            throw new RedisException("init redis client error, redis server is none.");
        }
        for (ZKRedisNode node : nodes) {
            this.groups.add(RedisGroup.from((com.mpush.tools.config.data.RedisGroup)node));
        }
        if (this.groups.isEmpty()) {
            throw new RedisException("init redis sever fail groupList is null");
        }
        Logs.Console.error("init redis cluster success...");
    }

    @Override
    public List<RedisGroup> getGroupList() {
        return Collections.unmodifiableList(this.groups);
    }

    public int groupSize() {
        return this.groups.size();
    }

    @Override
    public RedisServer randomGetRedisNode(String key) {
        int size = this.groupSize();
        if (size == 1) {
            return this.groups.get(0).get(key);
        }
        int i = (int)(Math.random() % (double)size * (double)size);
        RedisGroup group = this.groups.get(i);
        return group.get(key);
    }

    @Override
    public List<RedisServer> hashSet(String key) {
        ArrayList nodeList = Lists.newArrayList();
        for (RedisGroup group : this.groups) {
            RedisServer node = group.get(key);
            nodeList.add(node);
        }
        return nodeList;
    }

    private void register(List<com.mpush.tools.config.data.RedisGroup> groupList) {
        String data = Jsons.toJson(groupList);
        ZKClient.I.registerPersist(ZKPath.REDIS_SERVER.getRootPath(), data);
        Logs.Console.error("register redis server group success, group=" + data);
    }

    public void addGroup(RedisGroup group) {
        this.groups.add(group);
    }
}

