/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.BaseMessage;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;

public final class OkMessage
extends ByteBufMessage {
    public byte cmd;
    public byte code;
    public String data;

    public OkMessage(byte cmd, Packet message, Connection connection) {
        super(message, connection);
        this.cmd = cmd;
    }

    public OkMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.cmd = this.decodeByte(body);
        this.code = this.decodeByte(body);
        this.data = this.decodeString(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeByte(body, this.cmd);
        this.encodeByte(body, this.code);
        this.encodeString(body, this.data);
    }

    public static OkMessage from(BaseMessage src) {
        return new OkMessage(src.packet.cmd, new Packet(Command.OK, src.packet.sessionId), src.connection);
    }

    public OkMessage setCode(byte code) {
        this.code = code;
        return this;
    }

    public OkMessage setData(String data) {
        this.data = data;
        return this;
    }

    @Override
    public String toString() {
        return "OkMessage{cmd=" + this.cmd + ", code=" + this.code + ", data='" + this.data + '\'' + '}';
    }
}

