/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util;

import java.nio.ByteBuffer;

public final class ByteBuf {
    private ByteBuffer tmpNioBuf;

    public static ByteBuf allocate(int capacity) {
        ByteBuf buffer = new ByteBuf();
        buffer.tmpNioBuf = ByteBuffer.allocate(capacity);
        return buffer;
    }

    public static ByteBuf allocateDirect(int capacity) {
        ByteBuf buffer = new ByteBuf();
        buffer.tmpNioBuf = ByteBuffer.allocateDirect(capacity);
        return buffer;
    }

    public static ByteBuf wrap(byte[] array) {
        ByteBuf buffer = new ByteBuf();
        buffer.tmpNioBuf = ByteBuffer.wrap(array);
        return buffer;
    }

    public byte[] getArray() {
        this.tmpNioBuf.flip();
        byte[] array = new byte[this.tmpNioBuf.remaining()];
        this.tmpNioBuf.get(array);
        this.tmpNioBuf.compact();
        return array;
    }

    public ByteBuf get(byte[] array) {
        this.tmpNioBuf.get(array);
        return this;
    }

    public byte get() {
        return this.tmpNioBuf.get();
    }

    public ByteBuf put(byte b) {
        this.checkCapacity(1);
        this.tmpNioBuf.put(b);
        return this;
    }

    public short getShort() {
        return this.tmpNioBuf.getShort();
    }

    public ByteBuf putShort(int value) {
        this.checkCapacity(2);
        this.tmpNioBuf.putShort((short)value);
        return this;
    }

    public int getInt() {
        return this.tmpNioBuf.getInt();
    }

    public ByteBuf putInt(int value) {
        this.checkCapacity(4);
        this.tmpNioBuf.putInt(value);
        return this;
    }

    public long getLong() {
        return this.tmpNioBuf.getLong();
    }

    public ByteBuf putLong(long value) {
        this.checkCapacity(8);
        this.tmpNioBuf.putLong(value);
        return this;
    }

    public ByteBuf put(byte[] value) {
        this.checkCapacity(value.length);
        this.tmpNioBuf.put(value);
        return this;
    }

    public ByteBuf checkCapacity(int minWritableBytes) {
        int remaining = this.tmpNioBuf.remaining();
        if (remaining < minWritableBytes) {
            int newCapacity = this.newCapacity(this.tmpNioBuf.capacity() + minWritableBytes);
            ByteBuffer newBuffer = this.tmpNioBuf.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
            this.tmpNioBuf.flip();
            newBuffer.put(this.tmpNioBuf);
            this.tmpNioBuf = newBuffer;
        }
        return this;
    }

    private int newCapacity(int minNewCapacity) {
        int newCapacity;
        for (newCapacity = 64; newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        return newCapacity;
    }

    public ByteBuffer nioBuffer() {
        return this.tmpNioBuf;
    }

    public ByteBuf clear() {
        this.tmpNioBuf.clear();
        return this;
    }

    public ByteBuf flip() {
        this.tmpNioBuf.flip();
        return this;
    }
}

