/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;

public final class FastConnectMessage
extends ByteBufMessage {
    public String sessionId;
    public String deviceId;
    public int minHeartbeat;
    public int maxHeartbeat;

    public FastConnectMessage(Connection connection) {
        super(new Packet(Command.FAST_CONNECT, FastConnectMessage.genSessionId()), connection);
    }

    public FastConnectMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.sessionId = this.decodeString(body);
        this.deviceId = this.decodeString(body);
        this.minHeartbeat = this.decodeInt(body);
        this.maxHeartbeat = this.decodeInt(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeString(body, this.sessionId);
        this.encodeString(body, this.deviceId);
        this.encodeInt(body, this.minHeartbeat);
        this.encodeInt(body, this.maxHeartbeat);
    }

    @Override
    public String toString() {
        return "FastConnectMessage{sessionId='" + this.sessionId + '\'' + ", deviceId='" + this.deviceId + '\'' + ", minHeartbeat=" + this.minHeartbeat + ", maxHeartbeat=" + this.maxHeartbeat + '}';
    }
}

