/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.message.ByteBufMessage;
import com.mpush.message.HttpRequestMessage;
import com.mpush.util.ByteBuf;
import com.mpush.util.MPUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class HttpResponseMessage
extends ByteBufMessage {
    public int statusCode;
    public String reasonPhrase;
    public Map<String, String> headers;
    public byte[] body;

    public HttpResponseMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.statusCode = this.decodeInt(body);
        this.reasonPhrase = this.decodeString(body);
        this.headers = MPUtils.headerFromString(this.decodeString(body));
        this.body = this.decodeBytes(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeInt(body, this.statusCode);
        this.encodeString(body, this.reasonPhrase);
        this.encodeString(body, MPUtils.headerToString(this.headers));
        this.encodeBytes(body, this.body);
    }

    public static HttpResponseMessage from(HttpRequestMessage src) {
        return new HttpResponseMessage(src.createResponse(), src.connection);
    }

    public HttpResponseMessage setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HttpResponseMessage setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public HttpResponseMessage addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }
}

