/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util.crypto;

import com.mpush.api.Constants;
import com.mpush.client.ClientConfig;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AESUtils {
    public static final String KEY_ALGORITHM = "AES";
    public static final String KEY_ALGORITHM_PADDING = "AES/CBC/PKCS5Padding";

    public static byte[] encrypt(byte[] data, byte[] encryptKey, byte[] iv) {
        IvParameterSpec zeroIv = new IvParameterSpec(iv);
        SecretKeySpec key = new SecretKeySpec(encryptKey, KEY_ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(1, (Key)key, zeroIv);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            ClientConfig.I.getLogger().e(e, "encrypt ex, decryptKey=%s", new Object[]{encryptKey});
            return Constants.EMPTY_BYTES;
        }
    }

    public static byte[] decrypt(byte[] data, byte[] decryptKey, byte[] iv) {
        IvParameterSpec zeroIv = new IvParameterSpec(iv);
        SecretKeySpec key = new SecretKeySpec(decryptKey, KEY_ALGORITHM);
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(2, (Key)key, zeroIv);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            ClientConfig.I.getLogger().e(e, "decrypt ex, decryptKey=%s", new Object[]{decryptKey});
            return Constants.EMPTY_BYTES;
        }
    }
}

