/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.push;

import com.mpush.api.Constants;
import com.mpush.api.push.AckModel;
import com.mpush.api.push.PushCallback;

public final class PushContext {
    public byte[] content;
    public AckModel ackModel = AckModel.NO_ACK;
    public PushCallback callback;
    public int timeout = 1000;

    public PushContext(byte[] content) {
        this.content = content;
    }

    public static PushContext build(byte[] content) {
        return new PushContext(content);
    }

    public static PushContext build(String content) {
        return new PushContext(content.getBytes(Constants.UTF_8));
    }

    public byte[] getContent() {
        return this.content;
    }

    public PushContext setContent(byte[] content) {
        this.content = content;
        return this;
    }

    public AckModel getAckModel() {
        return this.ackModel;
    }

    public PushContext setAckModel(AckModel ackModel) {
        this.ackModel = ackModel;
        return this;
    }

    public PushCallback getCallback() {
        return this.callback;
    }

    public PushContext setCallback(PushCallback callback) {
        this.callback = callback;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public PushContext setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

