/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Logger;
import com.mpush.api.push.AckModel;
import com.mpush.api.push.PushCallback;
import com.mpush.api.push.PushContext;
import com.mpush.client.ClientConfig;
import com.mpush.util.thread.ExecutorManager;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class AckMessageQueue {
    private final Map<Integer, PushTask> queue = new ConcurrentHashMap<Integer, PushTask>();
    private final ScheduledExecutorService timer = ExecutorManager.INSTANCE.getHttpRequestThread();
    private final Callable<Boolean> NONE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return Boolean.FALSE;
        }
    };
    private final Logger logger = ClientConfig.I.getLogger();

    public Future<Boolean> add(int sessionId, PushContext context) {
        if (context.ackModel == AckModel.NO_ACK) {
            return null;
        }
        if (context.callback == null) {
            return null;
        }
        PushTask task = new PushTask(sessionId, context);
        this.queue.put(sessionId, task);
        task.future = this.timer.schedule(task, (long)task.timeout, TimeUnit.MILLISECONDS);
        return task;
    }

    public PushTask getAndRemove(int sessionId) {
        return this.queue.remove(sessionId);
    }

    public final class PushTask
    extends FutureTask<Boolean>
    implements Runnable {
        private PushCallback callback;
        private final int timeout;
        private final long sendTime;
        private final int sessionId;
        private Future<?> future;

        private PushTask(int sessionId, PushContext context) {
            super(AckMessageQueue.this.NONE);
            this.callback = context.getCallback();
            this.timeout = context.getTimeout();
            this.sendTime = System.currentTimeMillis();
            this.sessionId = sessionId;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void run() {
            AckMessageQueue.this.queue.remove(this.sessionId);
            this.timeout();
        }

        public void timeout() {
            this.call(false);
        }

        public void success() {
            this.call(true);
        }

        private void call(boolean success) {
            if (this.future.cancel(true)) {
                this.set(success);
                if (this.callback != null) {
                    if (success) {
                        this.callback.onSuccess();
                    } else {
                        this.callback.onTimeout();
                    }
                }
                this.callback = null;
            }
            AckMessageQueue.this.logger.d("one push task end, sessionId=%d, costTime=%d, success=%b", this.sessionId, System.currentTimeMillis() - this.sendTime, success);
        }
    }
}

