/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.handler;

import com.mpush.api.Logger;
import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.client.AckMessageQueue;
import com.mpush.client.ClientConfig;
import com.mpush.handler.BaseMessageHandler;
import com.mpush.message.AckMessage;

public class AckHandler
extends BaseMessageHandler<AckMessage> {
    private AckMessageQueue ackMessageQueue;
    private Logger logger;

    public AckHandler(AckMessageQueue ackMessageQueue) {
        this.ackMessageQueue = ackMessageQueue;
        this.logger = ClientConfig.I.getLogger();
    }

    @Override
    public AckMessage decode(Packet packet, Connection connection) {
        return new AckMessage(packet, connection);
    }

    @Override
    public void handle(AckMessage message) {
        AckMessageQueue.PushTask task = this.ackMessageQueue.getAndRemove(message.getSessionId());
        if (task == null) {
            this.logger.w("receive server ack, but timeout message={}", message);
            return;
        }
        task.success();
    }
}

