/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.handler;

import com.mpush.api.ClientListener;
import com.mpush.api.Logger;
import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.handler.BaseMessageHandler;
import com.mpush.message.AckMessage;
import com.mpush.message.PushMessage;

public final class PushMessageHandler
extends BaseMessageHandler<PushMessage> {
    private final Logger logger = ClientConfig.I.getLogger();
    private final ClientListener listener = ClientConfig.I.getClientListener();

    @Override
    public PushMessage decode(Packet packet, Connection connection) {
        return new PushMessage(packet, connection);
    }

    @Override
    public void handle(PushMessage message) {
        this.logger.d(">>> receive push message=%s", message.content.length);
        this.listener.onReceivePush(message.getConnection().getClient(), message.content, message.bizAck() ? message.getSessionId() : 0);
        if (message.autoAck()) {
            AckMessage.from(message).sendRaw();
            this.logger.d("<<< send ack for push messageId=%d", message.getSessionId());
        }
    }
}

