/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.BaseMessage;

public final class PushMessage
extends BaseMessage {
    public byte[] content;

    public PushMessage(byte[] content, Connection connection) {
        super(new Packet(Command.PUSH, PushMessage.genSessionId()), connection);
        this.content = content;
    }

    public PushMessage(Packet packet, Connection connection) {
        super(packet, connection);
    }

    @Override
    public void decode(byte[] body) {
        this.content = body;
    }

    @Override
    public byte[] encode() {
        return this.content;
    }

    public boolean autoAck() {
        return this.packet.hasFlag((byte)8);
    }

    public boolean bizAck() {
        return this.packet.hasFlag((byte)4);
    }

    public PushMessage addFlag(byte flag) {
        this.packet.addFlag(flag);
        return this;
    }

    @Override
    public String toString() {
        return "PushMessage{content='" + this.content.length + '\'' + '}';
    }
}

