/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.compress;

import com.github.myibu.algorithm.compress.Compressor;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class LZFCompressor
implements Compressor {
    private static final int LZF_HSLOT_BIAS = 0;
    private static final int HLOG = 16;
    private static final int HSIZE = 65536;
    private static final int MAX_LIT = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private boolean isDebug;

    private static int FRST(byte[] p, int offset) {
        return p[offset + 0] << 8 | p[offset + 1];
    }

    private static int NEXT(int v, byte[] p, int offset) {
        return v << 8 | p[offset + 2];
    }

    private static int IDX(int h) {
        return ((h ^ h << 5) >> 8) - h * 5 & 0xFFFF;
    }

    @Override
    public int compress(byte[] in_data, int in_len, byte[] out_data) {
        int out_len = out_data.length;
        if (in_len == 0 || out_len == 0) {
            return 0;
        }
        int ip = 0;
        int op = 0;
        int lit = 0;
        ++op;
        int[] htab = new int[65536];
        int hval = LZFCompressor.FRST(in_data, ip);
        while (ip < in_len - 2) {
            hval = LZFCompressor.NEXT(hval, in_data, ip);
            int hslot = LZFCompressor.IDX(hval);
            int ref = htab[hslot];
            htab[hslot] = ip;
            int off = ip - ref - 1;
            if (off < 8192 && ref < ip && in_data[ref + 0] == in_data[ip + 0] && in_data[ref + 1] == in_data[ip + 1] && in_data[ref + 2] == in_data[ip + 2]) {
                int len = 2;
                int maxlen = in_len - ip - len;
                int n = maxlen = maxlen > 264 ? 264 : maxlen;
                if (op + 3 + 1 >= out_len && op - (lit == 0 ? 1 : 0) + 3 + 1 >= out_len) {
                    return 0;
                }
                out_data[op - lit - 1] = (byte)(lit - 1);
                op -= lit == 0 ? 1 : 0;
                while (++len < maxlen && in_data[ref + len] == in_data[ip + len]) {
                }
                ++ip;
                if ((len -= 2) < 7) {
                    out_data[op++] = (byte)((off >> 8) + (len << 5));
                } else {
                    out_data[op++] = (byte)((off >> 8) + 224);
                    out_data[op++] = (byte)(len - 7);
                }
                out_data[op++] = (byte)off;
                lit = 0;
                ++op;
                hval = LZFCompressor.FRST(in_data, ip += len - 1);
                hval = LZFCompressor.NEXT(hval, in_data, ip);
                htab[LZFCompressor.IDX((int)hval)] = ip - 0;
                hval = LZFCompressor.NEXT(hval, in_data, ++ip);
                htab[LZFCompressor.IDX((int)hval)] = ip - 0;
                ++ip;
                continue;
            }
            out_data[op++] = in_data[ip++];
            if (++lit != 32) continue;
            out_data[op - lit - 1] = (byte)(lit - 1);
            lit = 0;
            ++op;
        }
        if (op + 3 > out_len) {
            return 0;
        }
        while (ip < in_len) {
            out_data[op++] = in_data[ip++];
            if (++lit != 32) continue;
            out_data[op - lit - 1] = (byte)(lit - 1);
            lit = 0;
            ++op;
        }
        out_data[op - lit - 1] = (byte)(lit - 1);
        op -= lit == 0 ? 1 : 0;
        if (this.isDebug) {
            System.out.println("after encode: compressed rate=" + new BigDecimal((double)op * 100.0 / (double)in_len).setScale(2, RoundingMode.HALF_UP) + "%");
        }
        return op;
    }

    @Override
    public int decompress(byte[] in_data, int in_len, byte[] out_data) {
        int out_len = out_data.length;
        int ip = 0;
        int op = 0;
        while (ip < in_len) {
            int ctrl;
            if ((ctrl = in_data[ip++] & 0xFF) < 32) {
                if (op + ++ctrl > out_len) {
                    if (this.isDebug) {
                        System.out.println("SET_ERRNO (E2BIG);");
                    }
                    return 0;
                }
                do {
                    out_data[op++] = in_data[ip++];
                } while (--ctrl > 0);
                continue;
            }
            int len = ctrl >> 5;
            int ref = op - ((ctrl & 0x1F) << 8) - 1;
            if (len == 7) {
                len += in_data[ip++] & 0xFF;
            }
            ref -= in_data[ip++] & 0xFF;
            if (op + len + 2 > out_len) {
                if (this.isDebug) {
                    System.out.println("SET_ERRNO (E2BIG);");
                }
                return 0;
            }
            if (ref < 0) {
                if (this.isDebug) {
                    System.out.println("SET_ERRNO (EINVAL);");
                }
                return 0;
            }
            out_data[op++] = out_data[ref++];
            out_data[op++] = out_data[ref++];
            do {
                out_data[op++] = out_data[ref++];
            } while (--len > 0);
        }
        return op;
    }

    @Override
    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }
}

