/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.random;

import com.github.myibu.algorithm.random.Random;
import java.util.concurrent.atomic.AtomicLong;

public class LinearCongruentialRandom
implements Random {
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);

    public LinearCongruentialRandom() {
        this(LinearCongruentialRandom.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 1181783497276652981L)) {
        }
        return next;
    }

    public LinearCongruentialRandom(long seed) {
        this.seed = new AtomicLong(LinearCongruentialRandom.initialScramble(seed));
    }

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long seed) {
        this.seed.set(LinearCongruentialRandom.initialScramble(seed));
    }

    public int next(int bits) {
        long nextseed;
        long oldseed;
        AtomicLong seed = this.seed;
        while (!seed.compareAndSet(oldseed = seed.get(), nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(nextseed >>> 48 - bits);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = this.next(31);
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.next(31);
            }
        }
        return r;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }
}

