/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.random;

import com.github.myibu.algorithm.random.Random;
import java.util.concurrent.atomic.AtomicLong;

public class MersenneTwisterRandom
implements Random {
    static final int MT19937_SIZE = 624;
    static final String BadBound = "bound must be positive";
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private final long seed;
    private long[] mt;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);

    public MersenneTwisterRandom() {
        this((int)(MersenneTwisterRandom.seedUniquifier() ^ System.nanoTime()));
    }

    public MersenneTwisterRandom(long seed) {
        this.seed = seed;
        this.mt = new long[624];
        this.mt[0] = seed;
        for (int i = 1; i < 624; ++i) {
            this.mt[i] = 1812433253L * (this.mt[i - 1] ^ this.mt[i - 1] >> 30) + (long)i;
        }
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 1181783497276652981L)) {
        }
        return next;
    }

    private void generate() {
        for (int i = 0; i < 624; ++i) {
            long y = (this.mt[i] & 0x80000000L) + (this.mt[(i + 1) % 624] & Integer.MAX_VALUE);
            this.mt[i] = this.mt[(i + 397) % 624] ^ y >> 1;
            if ((y & 1L) == 0L) continue;
            int n = i;
            this.mt[n] = this.mt[n] ^ 0x9908B0DFL;
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            int rnd = this.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Override
    public int nextInt() {
        this.generate();
        long y = this.mt[0];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680L;
        y ^= y << 15 & 0xEFC60000L;
        y ^= y >> 18;
        return (int)y;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int r = this.nextInt();
        int m = bound - 1;
        if ((bound & m) == 0) {
            r = (int)((long)bound * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % bound) + m < 0) {
                u = this.nextInt();
            }
        }
        return r;
    }

    @Override
    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    @Override
    public boolean nextBoolean() {
        return (this.nextInt() & 1) != 0;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextInt() / 1.6777216E7f;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.nextInt() << 27) + (long)this.nextInt()) * (double)1.110223E-16f;
    }
}

