/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.hash;

import com.github.myibu.algorithm.data.Bytes;

public class MurmurHash2 {
    public static long hash(byte[] key, int len, long seed) {
        long m = 1540483477L;
        int r = 24;
        long h = seed ^ (long)len;
        int offset = 0;
        while (len >= 4) {
            long k = Bytes.byteArrayToUnsignedInt(key, offset);
            k *= m;
            k ^= k >> r;
            h *= m;
            h ^= (k *= m);
            offset += 4;
            len -= 4;
        }
        switch (len) {
            case 3: {
                h ^= (long)(key[2] << 16);
            }
            case 2: {
                h ^= (long)(key[1] << 8);
            }
            case 1: {
                h ^= (long)key[0];
                h *= m;
            }
        }
        h ^= h >> 13;
        h *= m;
        h ^= h >> 15;
        return h;
    }
}

