/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.TimeSeriesChart;
import ec.util.chart.swing.ClusteredXYBarRenderer2;
import ec.util.chart.swing.SwingColorSchemeSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.EnumSet;
import lombok.NonNull;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Size2D;

abstract class JTimeSeriesRendererSupport
implements XYItemLabelGenerator,
XYSeriesLabelGenerator {
    private static final Shape ITEM_SHAPE = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);

    JTimeSeriesRendererSupport() {
    }

    public abstract Color getPlotColor();

    public abstract Color getSeriesColor(int var1);

    public abstract Stroke getSeriesStroke(int var1);

    public abstract Color getSeriesLabelColor(int var1);

    public abstract String getSeriesLabel(int var1);

    public abstract Font getSeriesLabelFont(int var1);

    public abstract boolean isSeriesLabelVisible(int var1);

    public abstract Color getObsColor(int var1, int var2);

    public abstract Stroke getObsStroke(int var1, int var2);

    public abstract boolean isObsHighlighted(int var1, int var2);

    public abstract String getObsLabel(int var1, int var2);

    public abstract Font getObsLabelFont(int var1, int var2);

    public abstract boolean isObsLabelVisible(int var1, int var2);

    public final String generateLabel(XYDataset dataset, int series, int item) {
        return this.getObsLabel(series, item);
    }

    public final String generateLabel(XYDataset dataset, int series) {
        return this.getSeriesLabel(series);
    }

    public final void drawItemLabel(Graphics2D g2, XYDataset dataset, int series, int item, double x, double y) {
        String label = this.generateLabel(dataset, series, item);
        Font font = this.getObsLabelFont(series, item);
        Color fillColor = this.getObsColor(series, item);
        Color paint = JTimeSeriesRendererSupport.getForegroundColor(SwingColorSchemeSupport.getLuminance(fillColor));
        Color outlinePaint = this.getPlotColor();
        Stroke outlineStroke = AbstractRenderer.DEFAULT_STROKE;
        JTimeSeriesRendererSupport.drawToolTip(g2, x, y, 3.0, label, font, paint, fillColor, outlinePaint, outlineStroke);
    }

    @NonNull
    public EnumSet<TimeSeriesChart.RendererType> getSupportedRendererTypes() {
        return EnumSet.of(TimeSeriesChart.RendererType.LINE, new TimeSeriesChart.RendererType[]{TimeSeriesChart.RendererType.COLUMN, TimeSeriesChart.RendererType.SPLINE, TimeSeriesChart.RendererType.STACKED_COLUMN, TimeSeriesChart.RendererType.MARKER, TimeSeriesChart.RendererType.AREA, TimeSeriesChart.RendererType.STACKED_AREA});
    }

    @NonNull
    public XYItemRenderer createRenderer(@NonNull TimeSeriesChart.RendererType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        switch (type) {
            case LINE: {
                return new LineRenderer(this);
            }
            case SPLINE: {
                return new SplineRenderer(this);
            }
            case COLUMN: {
                return new BarRenderer(this);
            }
            case MARKER: {
                return new MarkerRenderer(this);
            }
            case STACKED_COLUMN: {
                return new StackedBarRenderer(this);
            }
            case AREA: {
                return new AreaRenderer(this);
            }
            case STACKED_AREA: {
                return new StackedAreaRenderer(this);
            }
        }
        throw new RuntimeException("Not implemented");
    }

    static void drawToolTip(Graphics2D g2, double x, double y, double anchorOffset, String label, Font font, Paint paint, Paint fillPaint, Paint outlinePaint, Stroke outlineStroke) {
        LabelBlock block = new LabelBlock(label, font, paint);
        block.setMargin(3.0, 3.0, 3.0, 3.0);
        Rectangle2D hotspot = JTimeSeriesRendererSupport.createHotspot(g2, x, y, anchorOffset + 10.0, block.arrange(g2));
        Shape shape = JTimeSeriesRendererSupport.createShape(x, y, hotspot);
        if (fillPaint != null) {
            g2.setPaint(fillPaint);
            g2.fill(shape);
        }
        if (outlinePaint != null && outlineStroke != null) {
            g2.setStroke(outlineStroke);
            g2.setPaint(outlinePaint);
            g2.draw(shape);
        }
        block.draw(g2, hotspot);
    }

    private static Color getForegroundColor(double luminance) {
        return luminance > 127.0 ? Color.BLACK : Color.WHITE;
    }

    private static Shape createShape(double x, double y, Rectangle2D hotspot) {
        Area result = new Area(new RoundRectangle2D.Double(hotspot.getX(), hotspot.getY(), hotspot.getWidth(), hotspot.getHeight(), 8.0, 8.0));
        boolean right = hotspot.getMinX() > x;
        Polygon po = new Polygon();
        po.addPoint(0, 0);
        po.addPoint(0, 10);
        po.addPoint(10, 0);
        AffineTransform af = new AffineTransform();
        if (right) {
            af.translate(hotspot.getX() - 7.0, hotspot.getY() + hotspot.getHeight() / 2.0);
            af.rotate(-0.7853981633974483);
        } else {
            af.translate(hotspot.getMaxX() + 7.0, hotspot.getY() + hotspot.getHeight() / 2.0);
            af.rotate(2.356194490192345);
        }
        Shape shape = af.createTransformedShape(po);
        result.add(new Area(shape));
        return result;
    }

    private static Rectangle2D createHotspot(Graphics2D g2, double x, double y, double xOffset, Size2D blockSize) {
        Rectangle bounds = g2.getClipBounds();
        bounds = new Rectangle(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
        return JTimeSeriesRendererSupport.createHotspot(bounds, x, y, xOffset, blockSize);
    }

    private static Rectangle2D createHotspot(Rectangle bounds, double x, double y, double xOffset, Size2D blockSize) {
        double xx = x + xOffset + blockSize.width < bounds.getMaxX() ? x + xOffset : x - xOffset - blockSize.width;
        double halfHeight = blockSize.height / 2.0;
        double yy = y - halfHeight < bounds.getMinY() ? bounds.getMinY() : (y + halfHeight > bounds.getMaxY() ? bounds.getMaxY() - blockSize.height : y - halfHeight);
        return new Rectangle2D.Double(xx, yy, blockSize.width, blockSize.height);
    }

    private static class LineRenderer
    extends XYLineAndShapeRenderer {
        protected final JTimeSeriesRendererSupport support;

        public LineRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setBaseItemLabelsVisible(true);
            this.setAutoPopulateSeriesShape(false);
            this.setAutoPopulateSeriesFillPaint(false);
            this.setAutoPopulateSeriesOutlineStroke(false);
            this.setLegendLine(ITEM_SHAPE);
            this.setBaseShape(ITEM_SHAPE);
            this.setUseFillPaint(true);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
        }

        public boolean isItemLabelVisible(int series, int item) {
            return this.support.isObsLabelVisible(series, item);
        }

        public boolean getItemShapeVisible(int series, int item) {
            return this.support.isObsHighlighted(series, item);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            return this.support.getObsColor(series, item);
        }

        public Paint getItemFillPaint(int series, int item) {
            return this.support.getPlotColor();
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Stroke getSeriesStroke(int series) {
            return this.support.getSeriesStroke(series);
        }

        public Stroke getItemStroke(int series, int item) {
            return this.support.getObsStroke(series, item);
        }

        public Stroke getItemOutlineStroke(int series, int item) {
            return this.support.getSeriesStroke(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
        }

        protected void drawFirstPassShape(Graphics2D g2, int pass, int series, int item, Shape shape) {
            g2.setStroke(this.getItemStroke(series, item));
            g2.setPaint(this.getSeriesPaint(series));
            g2.draw(shape);
        }

        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            super.drawItem(g2, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
            if (pass == 2 && this.getItemVisible(series, item) && this.isItemLabelVisible(series, item)) {
                double x1 = dataset.getXValue(series, item);
                double y1 = dataset.getYValue(series, item);
                double transX1 = domainAxis.valueToJava2D(x1, dataArea, plot.getDomainAxisEdge());
                double transY1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
                this.support.drawItemLabel(g2, dataset, series, item, transX1, transY1);
            }
        }

        public int getPassCount() {
            return 3;
        }
    }

    private static class SplineRenderer
    extends XYSplineRenderer {
        private final JTimeSeriesRendererSupport support;

        public SplineRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setAutoPopulateSeriesShape(false);
            this.setLegendLine(ITEM_SHAPE);
            this.setBaseShape(ITEM_SHAPE);
            this.setUseFillPaint(true);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public boolean getItemShapeVisible(int series, int item) {
            return this.support.isObsHighlighted(series, item);
        }

        public boolean isItemLabelVisible(int series, int item) {
            return this.support.isObsLabelVisible(series, item);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemFillPaint(int series, int item) {
            return this.support.getPlotColor();
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Stroke getSeriesStroke(int series) {
            return this.support.getSeriesStroke(series);
        }

        public Stroke getItemStroke(int series, int item) {
            return this.support.getSeriesStroke(series);
        }

        public Stroke getItemOutlineStroke(int series, int item) {
            return this.support.getSeriesStroke(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
            this.support.drawItemLabel(g2, dataset, series, item, x, y);
        }
    }

    private static class BarRenderer
    extends ClusteredXYBarRenderer2 {
        private final JTimeSeriesRendererSupport support;

        public BarRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setAutoPopulateSeriesOutlineStroke(false);
            this.setMargin(0.1);
            this.setLegendBar(ITEM_SHAPE);
            this.setShadowVisible(false);
            this.setDrawBarOutline(true);
            this.setBaseItemLabelsVisible(true);
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setDrawBarOutline(false);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
        }

        public boolean isItemLabelVisible(int series, int item) {
            return this.support.isObsLabelVisible(series, item);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            Color result = this.support.getObsColor(series, item);
            return this.support.isObsHighlighted(series, item) ? result.brighter() : result;
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, XYDataset dataset, int series, int item, XYPlot plot, XYItemLabelGenerator generator, Rectangle2D bar, boolean negative) {
            this.support.drawItemLabel(g2, dataset, series, item, bar.getCenterX(), bar.getCenterY());
        }
    }

    private static class MarkerRenderer
    extends LineRenderer {
        public MarkerRenderer(JTimeSeriesRendererSupport support) {
            super(support);
        }

        public Boolean getSeriesLinesVisible(int series) {
            return Boolean.FALSE;
        }

        @Override
        public boolean getItemShapeVisible(int series, int item) {
            return true;
        }

        @Override
        public Stroke getItemOutlineStroke(int series, int item) {
            return this.support.getObsStroke(series, item);
        }

        public boolean getItemShapeFilled(int series, int item) {
            return this.support.isObsHighlighted(series, item);
        }

        @Override
        public Paint getItemFillPaint(int series, int item) {
            return this.support.getObsColor(series, item);
        }
    }

    private static class StackedBarRenderer
    extends StackedXYBarRenderer {
        private final JTimeSeriesRendererSupport support;

        public StackedBarRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setAutoPopulateSeriesOutlineStroke(false);
            this.setMargin(0.1);
            this.setLegendBar(ITEM_SHAPE);
            this.setShadowVisible(false);
            this.setDrawBarOutline(true);
            this.setBaseItemLabelsVisible(true);
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setDrawBarOutline(false);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
        }

        public Range findRangeBounds(XYDataset dataset) {
            return dataset.getSeriesCount() != 0 ? super.findRangeBounds(dataset) : null;
        }

        public boolean isItemLabelVisible(int series, int item) {
            return this.support.isObsLabelVisible(series, item);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            Color result = this.support.getObsColor(series, item);
            return this.support.isObsHighlighted(series, item) ? result.brighter() : result;
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, XYDataset dataset, int series, int item, XYPlot plot, XYItemLabelGenerator generator, Rectangle2D bar, boolean negative) {
            this.support.drawItemLabel(g2, dataset, series, item, bar.getCenterX(), bar.getCenterY());
        }
    }

    private static final class AreaRenderer
    extends XYAreaRenderer2 {
        private final JTimeSeriesRendererSupport support;

        public AreaRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setAutoPopulateSeriesShape(false);
            this.setAutoPopulateSeriesFillPaint(false);
            this.setAutoPopulateSeriesOutlineStroke(false);
            this.setBaseItemLabelsVisible(true);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
            this.setLegendArea(ITEM_SHAPE);
        }

        public boolean isItemLabelVisible(int row, int column) {
            return this.support.isObsLabelVisible(row, column);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            Color result = this.support.getObsColor(series, item);
            return this.support.isObsHighlighted(series, item) ? result.brighter() : result;
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
            this.support.drawItemLabel(g2, dataset, series, item, x, y);
        }
    }

    private static final class StackedAreaRenderer
    extends StackedXYAreaRenderer2 {
        private final JTimeSeriesRendererSupport support;

        public StackedAreaRenderer(JTimeSeriesRendererSupport support) {
            this.support = support;
            this.setAutoPopulateSeriesShape(false);
            this.setAutoPopulateSeriesFillPaint(false);
            this.setAutoPopulateSeriesOutlineStroke(false);
            this.setBaseItemLabelsVisible(true);
            this.setLegendItemLabelGenerator(support);
            this.setBaseItemLabelGenerator(support);
            this.setLegendArea(ITEM_SHAPE);
        }

        public boolean isItemLabelVisible(int row, int column) {
            return this.support.isObsLabelVisible(row, column);
        }

        public boolean isSeriesVisibleInLegend(int series) {
            return this.support.isSeriesLabelVisible(series);
        }

        public Paint getSeriesPaint(int series) {
            return this.support.getSeriesColor(series);
        }

        public Paint getItemPaint(int series, int item) {
            Color result = this.support.getObsColor(series, item);
            return this.support.isObsHighlighted(series, item) ? result.brighter() : result;
        }

        public Paint getLegendTextPaint(int series) {
            return this.support.getSeriesLabelColor(series);
        }

        public Font getLegendTextFont(int series) {
            return this.support.getSeriesLabelFont(series);
        }

        protected void drawItemLabel(Graphics2D g2, PlotOrientation orientation, XYDataset dataset, int series, int item, double x, double y, boolean negative) {
            this.support.drawItemLabel(g2, dataset, series, item, x, y);
        }
    }
}

