/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.ObsPredicate;
import ec.util.chart.SeriesFunction;
import ec.util.chart.SeriesPredicate;
import ec.util.chart.TimeSeriesChart;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TimeSeriesChartCommand {
    private static final TimeSeriesChartCommand CLEAR = new TimeSeriesChartCommand(){

        @Override
        public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            chart.setDataset(null);
        }
    };
    private static final Map<TimeSeriesChart.Element, TimeSeriesChartCommand> EVS = TimeSeriesChartCommand.createEVS();
    private static final Map<TimeSeriesChart.CrosshairOrientation, TimeSeriesChartCommand> CTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.CrosshairOrientation.class, "crosshairOrientation");
    private static final Map<TimeSeriesChart.DisplayTrigger, TimeSeriesChartCommand> TTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.DisplayTrigger.class, "tooltipTrigger");
    private static final Map<TimeSeriesChart.DisplayTrigger, TimeSeriesChartCommand> XTS = TimeSeriesChartCommand.allOf(TimeSeriesChart.DisplayTrigger.class, "crosshairTrigger");
    private static final TimeSeriesChartCommand COPY_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try {
                chart.copyImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    private static final TimeSeriesChartCommand SAVE_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try {
                chart.saveImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).warning(ex.getMessage());
            }
        }
    };
    private static final TimeSeriesChartCommand PRINT_IMAGE = new TimeSeriesChartCommand(){

        @Override
        public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try {
                chart.printImage();
            }
            catch (IOException ex) {
                Logger.getLogger(TimeSeriesChartCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };

    public abstract void execute(@NonNull TimeSeriesChart<?, ?> var1);

    public boolean isEnabled(@NonNull TimeSeriesChart<?, ?> chart) {
        if (chart == null) {
            throw new NullPointerException("chart is marked non-null but is null");
        }
        return true;
    }

    public boolean isSelected(@NonNull TimeSeriesChart<?, ?> chart) {
        if (chart == null) {
            throw new NullPointerException("chart is marked non-null but is null");
        }
        return false;
    }

    @NonNull
    public static TimeSeriesChartCommand reset() {
        return new TimeSeriesChartCommand(){

            @Override
            public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                chart.setDataset(null);
                chart.setColorSchemeSupport(null);
                chart.setTitle(null);
                chart.setNoDataMessage(null);
                for (TimeSeriesChart.Element o : TimeSeriesChart.Element.values()) {
                    chart.setElementVisible(o, true);
                }
                chart.setPlotWeights(null);
                chart.setPlotDispatcher(null);
                chart.setLineThickness(1.0f);
                chart.setPeriodFormat(null);
                chart.setValueFormat(null);
                chart.setSeriesRenderer(null);
                chart.setSeriesFormatter(null);
                chart.setObsFormatter(null);
                chart.setDashPredicate(null);
                chart.setLegendVisibilityPredicate(null);
                chart.setCrosshairOrientation(null);
                chart.setHoveredObs(null);
                chart.setObsHighlighter(null);
            }
        };
    }

    @NonNull
    public static TimeSeriesChartCommand clearDataset() {
        return CLEAR;
    }

    @NonNull
    public static TimeSeriesChartCommand toggleElementVisibility(@NonNull TimeSeriesChart.Element element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return EVS.get((Object)element);
    }

    @NonNull
    public static TimeSeriesChartCommand applyLineThickness(float thickness) {
        return new QuickCommand("lineThickness", Float.valueOf(thickness));
    }

    @NonNull
    public static TimeSeriesChartCommand applyDash(@Nullable ObsPredicate predicate) {
        return new QuickCommand("dashPredicate", predicate);
    }

    @NonNull
    public static TimeSeriesChartCommand applyLegendVisibility(@Nullable SeriesPredicate predicate) {
        return new QuickCommand("legendVisibilityPredicate", predicate);
    }

    @NonNull
    public static TimeSeriesChartCommand applyRenderer(@Nullable SeriesFunction<TimeSeriesChart.RendererType> renderer) {
        return new QuickCommand("seriesRenderer", renderer);
    }

    @NonNull
    public static TimeSeriesChartCommand applyRenderer(TimeSeriesChart.RendererType ... typeIndex) {
        if (typeIndex == null) {
            throw new NullPointerException("typeIndex is marked non-null but is null");
        }
        return TimeSeriesChartCommand.applyRenderer(SeriesFunction.array(typeIndex));
    }

    @NonNull
    public static TimeSeriesChartCommand applyPlotDispatcher(@Nullable SeriesFunction<Integer> plotDispatcher) {
        return new QuickCommand("plotDispatcher", plotDispatcher);
    }

    @NonNull
    public static TimeSeriesChartCommand applyPlotDispatcher(Integer ... plotIndex) {
        if (plotIndex == null) {
            throw new NullPointerException("plotIndex is marked non-null but is null");
        }
        return TimeSeriesChartCommand.applyPlotDispatcher(SeriesFunction.array(plotIndex));
    }

    @NonNull
    public static TimeSeriesChartCommand applySeriesFormatter(@Nullable SeriesFunction<String> formatter) {
        return new QuickCommand("seriesFormatter", formatter);
    }

    @NonNull
    public static TimeSeriesChartCommand applySeriesFormatter(String ... values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return TimeSeriesChartCommand.applySeriesFormatter(SeriesFunction.array(values));
    }

    @NonNull
    public static TimeSeriesChartCommand applyPeriod(@Nullable DateFormat periodFormat) {
        return new QuickCommand("periodFormat", periodFormat);
    }

    @NonNull
    public static TimeSeriesChartCommand applyPeriod(String format) {
        return TimeSeriesChartCommand.applyPeriod(new SimpleDateFormat(format));
    }

    @NonNull
    public static TimeSeriesChartCommand applyWeights(final int ... weights) {
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        return new TimeSeriesChartCommand(){

            @Override
            public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                chart.setPlotWeights(weights);
            }

            @Override
            public boolean isSelected(@NonNull TimeSeriesChart<?, ?> chart) {
                if (chart == null) {
                    throw new NullPointerException("chart is marked non-null but is null");
                }
                return Arrays.equals(weights, chart.getPlotWeights());
            }
        };
    }

    @NonNull
    public static TimeSeriesChartCommand applyTitle(@Nullable String title) {
        return new QuickCommand("title", title);
    }

    @NonNull
    public static TimeSeriesChartCommand applyCrosshairOrientation(@NonNull TimeSeriesChart.CrosshairOrientation crosshairOrientation) {
        if (crosshairOrientation == null) {
            throw new NullPointerException("crosshairOrientation is marked non-null but is null");
        }
        return CTS.get((Object)crosshairOrientation);
    }

    @NonNull
    public static TimeSeriesChartCommand applyObsHighlighter(@Nullable ObsPredicate obsHighlighter) {
        return new QuickCommand("obsHighlighter", obsHighlighter);
    }

    @NonNull
    public static TimeSeriesChartCommand applyTooltipTrigger(@NonNull TimeSeriesChart.DisplayTrigger tooltipTrigger) {
        if (tooltipTrigger == null) {
            throw new NullPointerException("tooltipTrigger is marked non-null but is null");
        }
        return TTS.get((Object)tooltipTrigger);
    }

    @NonNull
    public static TimeSeriesChartCommand applyCrosshairTrigger(@NonNull TimeSeriesChart.DisplayTrigger crosshairTrigger) {
        if (crosshairTrigger == null) {
            throw new NullPointerException("crosshairTrigger is marked non-null but is null");
        }
        return XTS.get((Object)crosshairTrigger);
    }

    @NonNull
    public static TimeSeriesChartCommand copyImage() {
        return COPY_IMAGE;
    }

    @NonNull
    public static TimeSeriesChartCommand saveImage() {
        return SAVE_IMAGE;
    }

    @NonNull
    public static TimeSeriesChartCommand printImage() {
        return PRINT_IMAGE;
    }

    private static EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand> createEVS() {
        EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand> result = new EnumMap<TimeSeriesChart.Element, TimeSeriesChartCommand>(TimeSeriesChart.Element.class);
        for (final TimeSeriesChart.Element o : TimeSeriesChart.Element.values()) {
            result.put(o, new TimeSeriesChartCommand(){

                @Override
                public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
                    if (chart == null) {
                        throw new NullPointerException("chart is marked non-null but is null");
                    }
                    chart.setElementVisible(o, !chart.isElementVisible(o));
                }

                @Override
                public boolean isSelected(@NonNull TimeSeriesChart<?, ?> chart) {
                    if (chart == null) {
                        throw new NullPointerException("chart is marked non-null but is null");
                    }
                    return chart.isElementVisible(o);
                }
            });
        }
        return result;
    }

    private static <T extends Enum<T>> Map<T, TimeSeriesChartCommand> allOf(Class<T> clazz, String propertyName) {
        EnumMap<T, QuickCommand> result = new EnumMap<T, QuickCommand>(clazz);
        for (Enum o : (Enum[])clazz.getEnumConstants()) {
            result.put(o, new QuickCommand(propertyName, o));
        }
        return result;
    }

    private static final class QuickCommand
    extends TimeSeriesChartCommand {
        private final PropertyDescriptor property;
        private final Object value;

        public QuickCommand(String propertyName, Object value) {
            this.property = QuickCommand.lookupProperty(propertyName);
            this.value = value;
        }

        private static PropertyDescriptor lookupProperty(String propertyName) {
            try {
                for (PropertyDescriptor o : Introspector.getBeanInfo(TimeSeriesChart.class).getPropertyDescriptors()) {
                    if (!o.getName().equals(propertyName)) continue;
                    return o;
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            throw new IllegalArgumentException(propertyName);
        }

        @Override
        public void execute(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try {
                this.property.getWriteMethod().invoke(chart, this.value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean isSelected(@NonNull TimeSeriesChart<?, ?> chart) {
            if (chart == null) {
                throw new NullPointerException("chart is marked non-null but is null");
            }
            try {
                return Objects.equals(this.property.getReadMethod().invoke(chart, new Object[0]), this.value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

