/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.Charts;
import ec.util.various.swing.JCommand;
import java.io.IOException;
import java.util.EventListener;
import lombok.NonNull;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;

public abstract class ChartCommand
extends JCommand<ChartPanel> {
    @NonNull
    public JCommand.ActionAdapter toAction(@NonNull ChartPanel chartPanel) {
        if (chartPanel == null) {
            throw new NullPointerException("chartPanel is marked non-null but is null");
        }
        ChartActionAdapter result = new ChartActionAdapter(chartPanel);
        result.registerChartChange(chartPanel.getChart());
        return result;
    }

    public static ChartCommand copyImage() {
        return CopyImage.INSTANCE;
    }

    public static ChartCommand saveImage() {
        return SaveImage.INSTANCE;
    }

    public static ChartCommand printImage() {
        return PrintImage.INSTANCE;
    }

    public static ChartCommand resetZoom() {
        return ResetZoom.INSTANCE;
    }

    private class ChartActionAdapter
    extends JCommand.ActionAdapter {
        public ChartActionAdapter(ChartPanel component) {
            super((JCommand)ChartCommand.this, (Object)component);
        }

        public void registerChartChange(JFreeChart source) {
            ChartChangeListener realListener = event -> this.refreshActionState();
            this.putValue("ChartChangeListener", realListener);
            source.addChangeListener((ChartChangeListener)new WeakChartChangeListener(realListener){

                protected void unregister(@NonNull Object source) {
                    if (source == null) {
                        throw new NullPointerException("source is marked non-null but is null");
                    }
                    ((JFreeChart)source).removeChangeListener((ChartChangeListener)this);
                }
            });
        }
    }

    private static class CopyImage
    extends ChartCommand {
        static final CopyImage INSTANCE = new CopyImage();

        private CopyImage() {
        }

        public void execute(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            Charts.copyChart(chartPanel);
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            return new ChartActionAdapter(chartPanel);
        }
    }

    private static class SaveImage
    extends ChartCommand {
        static final SaveImage INSTANCE = new SaveImage();

        private SaveImage() {
        }

        public void execute(@NonNull ChartPanel chartPanel) throws IOException {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            Charts.saveChart(chartPanel);
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            return new ChartActionAdapter(chartPanel);
        }
    }

    private static class PrintImage
    extends ChartCommand {
        static final PrintImage INSTANCE = new PrintImage();

        private PrintImage() {
        }

        public void execute(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            chartPanel.createChartPrintJob();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            return new ChartActionAdapter(chartPanel);
        }
    }

    private static class ResetZoom
    extends ChartCommand {
        static final ResetZoom INSTANCE = new ResetZoom();

        private ResetZoom() {
        }

        public void execute(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            chartPanel.restoreAutoBounds();
        }

        @Override
        @NonNull
        public JCommand.ActionAdapter toAction(@NonNull ChartPanel chartPanel) {
            if (chartPanel == null) {
                throw new NullPointerException("chartPanel is marked non-null but is null");
            }
            return new ChartActionAdapter(chartPanel);
        }
    }

    private static abstract class WeakChartChangeListener
    extends JCommand.WeakEventListener<ChartChangeListener>
    implements ChartChangeListener {
        public WeakChartChangeListener(ChartChangeListener delegate) {
            super((EventListener)delegate);
        }

        public void chartChanged(ChartChangeEvent event) {
            ChartChangeListener listener = (ChartChangeListener)this.delegate.get();
            if (listener != null) {
                listener.chartChanged(event);
            } else {
                this.unregister(event.getSource());
            }
        }
    }
}

