/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.Charts;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.general.SeriesDataset;

public class SelectionMouseListener
extends MouseAdapter {
    protected final ListSelectionModel listSelectionModel;
    protected final boolean dragEnabled;

    public SelectionMouseListener(@NonNull ListSelectionModel listSelectionModel, boolean dragEnabled) {
        if (listSelectionModel == null) {
            throw new NullPointerException("listSelectionModel is marked non-null but is null");
        }
        this.listSelectionModel = listSelectionModel;
        this.dragEnabled = dragEnabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (Charts.isPopup(e) || Charts.isDoubleClick(e)) {
            return;
        }
        int index = this.getSelectionIndex(e);
        if (-1 != index) {
            ChartPanel chartPanel;
            TransferHandler transferHandler;
            if (e.isControlDown()) {
                if (this.listSelectionModel.isSelectedIndex(index)) {
                    this.listSelectionModel.removeSelectionInterval(index, index);
                } else {
                    this.listSelectionModel.addSelectionInterval(index, index);
                }
            } else {
                this.listSelectionModel.setSelectionInterval(index, index);
            }
            if (this.dragEnabled && e.getSource() instanceof ChartPanel && (transferHandler = (chartPanel = (ChartPanel)e.getSource()).getTransferHandler()) != null) {
                transferHandler.exportAsDrag((JComponent)chartPanel, e, 1);
            }
        } else {
            this.listSelectionModel.clearSelection();
        }
    }

    protected int getSelectionIndex(@NonNull MouseEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        return this.getSelectionIndex(SelectionMouseListener.getSelection(e));
    }

    protected int getSelectionIndex(@Nullable LegendItemEntity entity) {
        return entity != null ? ((SeriesDataset)entity.getDataset()).indexOf(entity.getSeriesKey()) : -1;
    }

    private static @Nullable LegendItemEntity getSelection(@NonNull MouseEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        ChartPanel chartPanel = (ChartPanel)e.getSource();
        ChartEntity entity = chartPanel.getEntityForPoint(e.getX(), e.getY());
        if (entity instanceof LegendItemEntity) {
            return (LegendItemEntity)entity;
        }
        if (entity instanceof XYItemEntity) {
            XYItemEntity tmp = (XYItemEntity)entity;
            return Charts.createFakeLegendItemEntity(tmp.getDataset(), tmp.getDataset().getSeriesKey(tmp.getSeriesIndex()));
        }
        if (entity instanceof PlotEntity) {
            return Charts.getSeriesForPoint(e.getPoint(), chartPanel);
        }
        return null;
    }
}

