/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface IOConsumer<T> {
    public void acceptWithIO(T var1) throws IOException;

    default public @NonNull IOConsumer<T> andThen(@NonNull IOConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.acceptWithIO(t);
            after.acceptWithIO(t);
        };
    }

    default public @NonNull Consumer<T> asUnchecked() {
        return t -> {
            try {
                this.acceptWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> @NonNull Consumer<T> unchecked(@NonNull IOConsumer<T> o) {
        return o.asUnchecked();
    }

    public static <T> @NonNull IOConsumer<T> checked(@NonNull Consumer<T> consumer) {
        return o -> {
            try {
                consumer.accept(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> @NonNull IOConsumer<T> noOp() {
        return o -> {};
    }
}

