/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface IORunnable {
    public void runWithIO() throws IOException;

    default public @NonNull Closeable asCloseable() {
        return this::runWithIO;
    }

    default public @NonNull Runnable asUnchecked() {
        return () -> {
            try {
                this.runWithIO();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static @NonNull Runnable unchecked(@NonNull IORunnable o) {
        return o.asUnchecked();
    }

    public static @NonNull IORunnable checked(@NonNull Runnable o) {
        return () -> {
            try {
                o.run();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        };
    }

    public static @NonNull IORunnable noOp() {
        return () -> {};
    }
}

