/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Supplier;
import nbbrd.io.function.IOFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface IOSupplier<T> {
    public T getWithIO() throws IOException;

    default public <V> @NonNull IOSupplier<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
        Objects.requireNonNull(after);
        return () -> after.applyWithIO((T)this.getWithIO());
    }

    default public @NonNull Supplier<T> asUnchecked() {
        return () -> {
            try {
                return this.getWithIO();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> @NonNull Supplier<T> unchecked(@NonNull IOSupplier<T> o) {
        return o.asUnchecked();
    }

    public static <T> @NonNull IOSupplier<T> checked(@NonNull Supplier<T> o) {
        Objects.requireNonNull(o);
        return () -> {
            try {
                return o.get();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        };
    }

    public static <T> @NonNull IOSupplier<T> of(@Nullable T t) {
        return () -> t;
    }
}

