/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IntProperty
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final int defaultValue;

    public int get(@lombok.NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Integer result = Parser.onInteger().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public int get(@lombok.NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public int get(@lombok.NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@lombok.NonNull BiConsumer<? super String, ? super String> properties, int value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onInteger().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@lombok.NonNull Properties properties, int value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@lombok.NonNull Map<String, String> properties, int value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private IntProperty(@lombok.NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @NonNull IntProperty of(@lombok.NonNull String key, int defaultValue) {
        return new IntProperty(key, defaultValue);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getDefaultValue() {
        return this.defaultValue;
    }
}

