/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.AndThenTextParser;
import internal.io.text.FunctionalTextParser;
import internal.io.text.InternalParser;
import internal.io.text.InternalTextResource;
import internal.io.text.LegacyFiles;
import internal.io.text.WithCharsetFileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;
import nbbrd.io.FileParser;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.Parser;

public interface TextParser<T> {
    @NonNull
    default public T parseChars(@NonNull CharSequence source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Reader reader = LegacyFiles.openReader(source);){
            T t = this.parseReader(reader);
            return t;
        }
    }

    @NonNull
    default public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStream resource = LegacyFiles.openInputStream(source);){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    @NonNull
    default public T parsePath(@NonNull Path source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        Optional<File> file = Resource.getFile(source);
        return file.isPresent() ? this.parseFile(file.get(), encoding) : this.parseStream(() -> Files.newInputStream(source, new OpenOption[0]), encoding);
    }

    @NonNull
    default public T parseResource(@NonNull Class<?> type, @NonNull String name, @NonNull Charset encoding) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStream resource = LegacyFiles.openResource(type, name);){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    @NonNull
    default public T parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Reader resource = LegacyFiles.openReader(source);){
            T t = this.parseReader(resource);
            return t;
        }
    }

    @NonNull
    default public T parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStream resource = LegacyFiles.openInputStream(source);){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    @NonNull
    public T parseReader(@NonNull Reader var1) throws IOException;

    @NonNull
    public T parseStream(@NonNull InputStream var1, @NonNull Charset var2) throws IOException;

    @NonNull
    default public <V> TextParser<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return new AndThenTextParser<T, V>(this, after);
    }

    @NonNull
    default public FileParser<T> asFileParser(@NonNull Charset encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        return new WithCharsetFileParser(this, encoding);
    }

    @NonNull
    default public Parser<T> asParser() {
        return this.asParser(InternalParser::doNothing);
    }

    @NonNull
    default public Parser<T> asParser(@NonNull Consumer<? super Throwable> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        return chars -> {
            if (chars != null) {
                try {
                    return this.parseChars(chars);
                }
                catch (Throwable ex) {
                    onError.accept(ex);
                }
            }
            return null;
        };
    }

    @NonNull
    public static <T> TextParser<T> onParsingReader(@NonNull IOFunction<? super Reader, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalTextParser<T>(function);
    }

    @NonNull
    public static <T> TextParser<T> onParsingLines(@NonNull Function<? super Stream<String>, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalTextParser<T>(IOFunction.checked(function).compose(InternalTextResource::asLines));
    }
}

