/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.xml.bind;

import internal.io.text.FileSystemExceptions;
import internal.io.text.LegacyFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.xml.Sax;
import nbbrd.io.xml.Stax;
import nbbrd.io.xml.Xml;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Jaxb {
    @NonNull
    public static Unmarshaller createUnmarshaller(@NonNull Class<?> type) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    @NonNull
    public static Unmarshaller createUnmarshaller(@NonNull JAXBContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        try {
            return context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    @NonNull
    public static Marshaller createMarshaller(@NonNull Class<?> type) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type}).createMarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    @NonNull
    public static Marshaller createMarshaller(@NonNull JAXBContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        try {
            return context.createMarshaller();
        }
        catch (JAXBException ex) {
            throw Jaxb.toIOException(ex);
        }
    }

    private static IOException toIOException(JAXBException ex) {
        if (Jaxb.hasLinkedException(ex)) {
            if (ex.getCause() instanceof XMLStreamException) {
                return Stax.toIOException((XMLStreamException)((XMLStreamException)ex.getCause()));
            }
            if (ex.getCause() instanceof SAXParseException) {
                return Sax.toIOException((SAXException)((SAXParseException)ex.getCause()));
            }
        }
        return WrappedIOException.wrap((Throwable)ex);
    }

    private static boolean hasLinkedException(JAXBException ex) {
        return ex.getCause() != null && ex.getMessage() == null;
    }

    @Generated
    private Jaxb() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Formatter<T>
    implements Xml.Formatter<T> {
        @NonNull
        private final IOSupplier<? extends Marshaller> factory;
        private final boolean formatted;
        @NonNull
        private final Charset encoding;

        @NonNull
        public static <T> Formatter<T> of(@NonNull Class<T> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            return Formatter.builder().factory((IOSupplier<Marshaller>)((IOSupplier)() -> Jaxb.createMarshaller(type))).build();
        }

        @NonNull
        public static <T> Formatter<T> of(@NonNull JAXBContext context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            return Formatter.builder().factory((IOSupplier<Marshaller>)((IOSupplier)() -> Jaxb.createMarshaller(context))).build();
        }

        @NonNull
        public Charset getDefaultEncoding() {
            return this.encoding;
        }

        public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            FileSystemExceptions.checkTarget((File)target);
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, target);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            try {
                this.getEngine(this.getDefaultEncoding()).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            try {
                this.getEngine(encoding).marshal(value, resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private Marshaller getEngine(Charset selectedEncoding) throws PropertyException, IOException {
            Marshaller result = (Marshaller)this.factory.getWithIO();
            result.setProperty("jaxb.formatted.output", (Object)this.formatted);
            result.setProperty("jaxb.encoding", (Object)selectedEncoding.name());
            return result;
        }

        @Generated
        private static <T> boolean $default$formatted() {
            return false;
        }

        @Generated
        private static <T> Charset $default$encoding() {
            return StandardCharsets.UTF_8;
        }

        @Generated
        Formatter(@NonNull IOSupplier<? extends Marshaller> factory, boolean formatted, @NonNull Charset encoding) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            this.factory = factory;
            this.formatted = formatted;
            this.encoding = encoding;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder().factory(this.factory).formatted(this.formatted).encoding(this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withFactory(@NonNull IOSupplier<? extends Marshaller> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Formatter<T>(factory, this.formatted, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withFormatted(boolean formatted) {
            return this.formatted == formatted ? this : new Formatter<T>(this.factory, formatted, this.encoding);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> withEncoding(@NonNull Charset encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            return this.encoding == encoding ? this : new Formatter<T>(this.factory, this.formatted, encoding);
        }

        @Generated
        public boolean isFormatted() {
            return this.formatted;
        }

        public static final class Builder<T> {
            @Generated
            private IOSupplier<? extends Marshaller> factory;
            @Generated
            private boolean formatted$set;
            @Generated
            private boolean formatted$value;
            @Generated
            private boolean encoding$set;
            @Generated
            private Charset encoding$value;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends Marshaller> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> formatted(boolean formatted) {
                this.formatted$value = formatted;
                this.formatted$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> encoding(@NonNull Charset encoding) {
                if (encoding == null) {
                    throw new NullPointerException("encoding is marked non-null but is null");
                }
                this.encoding$value = encoding;
                this.encoding$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Formatter<T> build() {
                boolean formatted$value = this.formatted$value;
                if (!this.formatted$set) {
                    formatted$value = Formatter.$default$formatted();
                }
                Charset encoding$value = this.encoding$value;
                if (!this.encoding$set) {
                    encoding$value = Formatter.$default$encoding();
                }
                return new Formatter(this.factory, formatted$value, encoding$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Jaxb.Formatter.Builder(factory=" + this.factory + ", formatted$value=" + this.formatted$value + ", encoding$value=" + this.encoding$value + ")";
            }
        }
    }

    public static final class Parser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final IOSupplier<? extends Unmarshaller> factory;
        private final boolean ignoreXXE;
        @NonNull
        private final IOSupplier<? extends XMLInputFactory> xxeFactory;

        @NonNull
        public static <T> Parser<T> of(@NonNull Class<T> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            return Parser.builder().factory((IOSupplier<Unmarshaller>)((IOSupplier)() -> Jaxb.createUnmarshaller(type))).build();
        }

        @NonNull
        public static <T> Parser<T> of(@NonNull JAXBContext context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            return Parser.builder().factory((IOSupplier<Unmarshaller>)((IOSupplier)() -> Jaxb.createUnmarshaller(context))).build();
        }

        @NonNull
        public T parseFile(@NonNull File source) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            FileSystemExceptions.checkSource((File)source);
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return this.cast(!this.ignoreXXE ? Parser.parseFileXXE(engine, source, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseFile(engine, source));
        }

        @NonNull
        public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            FileSystemExceptions.checkSource((File)source);
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return this.cast(!this.ignoreXXE ? Parser.parseFileXXE(engine, source, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseFile(engine, source, encoding));
        }

        @NonNull
        public T parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return this.cast(!this.ignoreXXE ? Parser.parseReaderXXE(engine, resource, (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseReader(engine, resource));
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return this.cast(!this.ignoreXXE ? Parser.parseStreamXXE(engine, Resource.uncloseableInputStream((InputStream)resource), (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseStream(engine, Resource.uncloseableInputStream((InputStream)resource)));
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            Unmarshaller engine = (Unmarshaller)this.factory.getWithIO();
            return this.cast(!this.ignoreXXE ? Parser.parseStreamXXE(engine, Resource.uncloseableInputStream((InputStream)resource), (XMLInputFactory)this.xxeFactory.getWithIO()) : Parser.parseStream(engine, Resource.uncloseableInputStream((InputStream)resource)));
        }

        private T cast(Object value) {
            return (T)value;
        }

        private static XMLInputFactory getStaxFactory() {
            XMLInputFactory result = XMLInputFactory.newInstance();
            Stax.preventXXE((XMLInputFactory)result);
            return result;
        }

        private static Object parseFile(Unmarshaller engine, File source) throws IOException {
            try {
                return engine.unmarshal(Sax.newInputSource((File)source));
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static Object parseFile(Unmarshaller engine, File source, Charset encoding) throws IOException {
            try {
                return engine.unmarshal(Sax.newInputSource((File)source, (Charset)encoding));
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static Object parseReader(Unmarshaller engine, Reader resource) throws IOException {
            try {
                return engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        private static Object parseStream(Unmarshaller engine, InputStream resource) throws IOException {
            try {
                return engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private static Object parseFileXXE(Unmarshaller engine, File source, XMLInputFactory xxe) throws IOException {
            try (InputStream resource = LegacyFiles.openInputStream((File)source);){
                Object object;
                XMLStreamReader reader = xxe.createXMLStreamReader(LegacyFiles.toSystemId((File)source), resource);
                try {
                    object = engine.unmarshal(reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return object;
            }
            catch (XMLStreamException ex) {
                throw Stax.toIOException((XMLStreamException)ex);
            }
            catch (JAXBException ex) {
                throw Jaxb.toIOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object parseReaderXXE(Unmarshaller engine, Reader resource, XMLInputFactory xxe) throws IOException {
            Object object;
            XMLStreamReader reader = xxe.createXMLStreamReader(resource);
            try {
                object = engine.unmarshal(reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException ex) {
                    throw Stax.toIOException((XMLStreamException)ex);
                }
                catch (JAXBException ex) {
                    throw Jaxb.toIOException(ex);
                }
            }
            reader.close();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object parseStreamXXE(Unmarshaller engine, InputStream resource, XMLInputFactory xxe) throws IOException {
            Object object;
            XMLStreamReader reader = xxe.createXMLStreamReader(resource);
            try {
                object = engine.unmarshal(reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException ex) {
                    throw Stax.toIOException((XMLStreamException)ex);
                }
                catch (JAXBException ex) {
                    throw Jaxb.toIOException(ex);
                }
            }
            reader.close();
            return object;
        }

        @Generated
        private static <T> boolean $default$ignoreXXE() {
            return false;
        }

        @Generated
        private static <T> IOSupplier<? extends XMLInputFactory> $default$xxeFactory() {
            return Parser::getStaxFactory;
        }

        @Generated
        Parser(@NonNull IOSupplier<? extends Unmarshaller> factory, boolean ignoreXXE, @NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (xxeFactory == null) {
                throw new NullPointerException("xxeFactory is marked non-null but is null");
            }
            this.factory = factory;
            this.ignoreXXE = ignoreXXE;
            this.xxeFactory = xxeFactory;
        }

        @Generated
        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> toBuilder() {
            return new Builder().factory(this.factory).ignoreXXE(this.ignoreXXE).xxeFactory(this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withFactory(@NonNull IOSupplier<? extends Unmarshaller> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            return this.factory == factory ? this : new Parser<T>(factory, this.ignoreXXE, this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withIgnoreXXE(boolean ignoreXXE) {
            return this.ignoreXXE == ignoreXXE ? this : new Parser<T>(this.factory, ignoreXXE, this.xxeFactory);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> withXxeFactory(@NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
            if (xxeFactory == null) {
                throw new NullPointerException("xxeFactory is marked non-null but is null");
            }
            return this.xxeFactory == xxeFactory ? this : new Parser<T>(this.factory, this.ignoreXXE, xxeFactory);
        }

        @Generated
        public boolean isIgnoreXXE() {
            return this.ignoreXXE;
        }

        public static final class Builder<T> {
            @Generated
            private IOSupplier<? extends Unmarshaller> factory;
            @Generated
            private boolean ignoreXXE$set;
            @Generated
            private boolean ignoreXXE$value;
            @Generated
            private boolean xxeFactory$set;
            @Generated
            private IOSupplier<? extends XMLInputFactory> xxeFactory$value;

            @Generated
            Builder() {
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> factory(@NonNull IOSupplier<? extends Unmarshaller> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> ignoreXXE(boolean ignoreXXE) {
                this.ignoreXXE$value = ignoreXXE;
                this.ignoreXXE$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Builder<T> xxeFactory(@NonNull IOSupplier<? extends XMLInputFactory> xxeFactory) {
                if (xxeFactory == null) {
                    throw new NullPointerException("xxeFactory is marked non-null but is null");
                }
                this.xxeFactory$value = xxeFactory;
                this.xxeFactory$set = true;
                return this;
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull Parser<T> build() {
                boolean ignoreXXE$value = this.ignoreXXE$value;
                if (!this.ignoreXXE$set) {
                    ignoreXXE$value = Parser.$default$ignoreXXE();
                }
                IOSupplier xxeFactory$value = this.xxeFactory$value;
                if (!this.xxeFactory$set) {
                    xxeFactory$value = Parser.$default$xxeFactory();
                }
                return new Parser(this.factory, ignoreXXE$value, (IOSupplier<? extends XMLInputFactory>)xxeFactory$value);
            }

            @Generated
            public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
                return "Jaxb.Parser.Builder(factory=" + this.factory + ", ignoreXXE$value=" + this.ignoreXXE$value + ", xxeFactory$value=" + this.xxeFactory$value + ")";
            }
        }
    }
}

